/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public abstract class BaseAutoDeployListener
implements AutoDeployListener {
    private static Log _log = LogFactoryUtil.getLog(BaseAutoDeployListener.class);

    public boolean isExtPlugin(File file) {
        String fileName = file.getName();
        return fileName.contains("-ext");
    }

    public boolean isHookPlugin(File file) throws AutoDeployException {
        String fileName = file.getName();
        return this.isMatchingFile(file, "WEB-INF/liferay-hook.xml") && !this.isMatchingFile(file, "WEB-INF/liferay-portlet.xml") && !fileName.contains("-theme") && !fileName.contains("-web");
    }

    public boolean isLiferayPackage(File file) {
        String fileName = file.getName();
        return fileName.endsWith(".lpkg");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isMatchingFile(File file, String checkXmlFile) throws AutoDeployException {
        ZipFile zipFile;
        block12: {
            if (!this.isMatchingFileExtension(file)) {
                return false;
            }
            zipFile = null;
            try {
                zipFile = new ZipFile(file);
                if (zipFile.getEntry(checkXmlFile) != null) break block12;
                if (_log.isDebugEnabled()) {
                    _log.debug(String.valueOf(file.getPath()) + " does not have " + checkXmlFile);
                }
                if (zipFile == null) return false;
            }
            catch (IOException ioe) {
                try {
                    throw new AutoDeployException(ioe);
                }
                catch (Throwable throwable) {
                    if (zipFile == null) throw throwable;
                    try {
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                zipFile.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
        if (zipFile == null) return true;
        try {
            zipFile.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
    }

    public boolean isMatchingFileExtension(File file) {
        String fileName = file.getName();
        if ((fileName = fileName.toLowerCase()).endsWith(".war") || fileName.endsWith(".zip")) {
            if (_log.isDebugEnabled()) {
                _log.debug(String.valueOf(file.getPath()) + " has a matching extension");
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug(String.valueOf(file.getPath()) + " does not have a matching extension");
        }
        return false;
    }

    public boolean isThemePlugin(File file) throws AutoDeployException {
        if (this.isMatchingFile(file, "WEB-INF/liferay-look-and-feel.xml")) {
            return true;
        }
        String fileName = file.getName();
        return this.isMatchingFile(file, "WEB-INF/liferay-plugin-package.properties") && fileName.contains("-theme");
    }

    public boolean isWebPlugin(File file) throws AutoDeployException {
        String fileName = file.getName();
        return this.isMatchingFile(file, "WEB-INF/liferay-plugin-package.properties") && fileName.contains("-web");
    }
}

