/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.executor;

import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class CopyThreadLocalCallable<T>
implements Callable<T> {
    private final boolean _clearOnExit;
    private final Map<CentralizedThreadLocal<?>, Object> _longLivedThreadLocals;
    private final Map<CentralizedThreadLocal<?>, Object> _shortLivedlThreadLocals;

    public CopyThreadLocalCallable(boolean readOnly, boolean clearOnExit) {
        if (readOnly) {
            this._longLivedThreadLocals = Collections.unmodifiableMap(CentralizedThreadLocal.getLongLivedThreadLocals());
            this._shortLivedlThreadLocals = Collections.unmodifiableMap(CentralizedThreadLocal.getShortLivedThreadLocals());
        } else {
            this._longLivedThreadLocals = CentralizedThreadLocal.getLongLivedThreadLocals();
            this._shortLivedlThreadLocals = CentralizedThreadLocal.getShortLivedThreadLocals();
        }
        this._clearOnExit = clearOnExit;
    }

    @Override
    public final T call() throws Exception {
        CentralizedThreadLocal.setThreadLocals(this._longLivedThreadLocals, this._shortLivedlThreadLocals);
        try {
            T t = this.doCall();
            return t;
        }
        finally {
            if (this._clearOnExit) {
                CentralizedThreadLocal.clearLongLivedThreadLocals();
                CentralizedThreadLocal.clearShortLivedThreadLocals();
            }
        }
    }

    public abstract T doCall() throws Exception;
}

