/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.image;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ImageToolUtil {
    private static ImageTool _imageTool;

    public static BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        return ImageToolUtil.getImageTool().convertImageType(sourceImage, type);
    }

    public static void encodeGIF(RenderedImage renderedImage, OutputStream os) throws IOException {
        ImageToolUtil.getImageTool().encodeGIF(renderedImage, os);
    }

    public static void encodeWBMP(RenderedImage renderedImage, OutputStream os) throws InterruptedException, IOException {
        ImageToolUtil.getImageTool().encodeWBMP(renderedImage, os);
    }

    public static BufferedImage getBufferedImage(RenderedImage renderedImage) {
        return ImageToolUtil.getImageTool().getBufferedImage(renderedImage);
    }

    public static byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        return ImageToolUtil.getImageTool().getBytes(renderedImage, contentType);
    }

    public static ImageTool getImageTool() {
        PortalRuntimePermission.checkGetBeanProperty(ImageToolUtil.class);
        return _imageTool;
    }

    public static ImageBag read(byte[] bytes) throws IOException {
        return ImageToolUtil.getImageTool().read(bytes);
    }

    public static ImageBag read(File file) throws IOException {
        return ImageToolUtil.getImageTool().read(file);
    }

    public static RenderedImage scale(RenderedImage renderedImage, int width) {
        return ImageToolUtil.getImageTool().scale(renderedImage, width);
    }

    public static RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        return ImageToolUtil.getImageTool().scale(renderedImage, maxHeight, maxWidth);
    }

    public static void write(RenderedImage renderedImage, String contentType, OutputStream os) throws IOException {
        ImageToolUtil.getImageTool().write(renderedImage, contentType, os);
    }

    public void setImageTool(ImageTool imageTool) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _imageTool = imageTool;
    }
}

