/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class BaseAsyncDestination
extends BaseDestination {
    private static final int _WORKERS_CORE_SIZE = 2;
    private static final int _WORKERS_MAX_SIZE = 5;
    private static Log _log = LogFactoryUtil.getLog(BaseAsyncDestination.class);
    private int _maximumQueueSize = Integer.MAX_VALUE;
    private RejectedExecutionHandler _rejectedExecutionHandler;
    private ThreadPoolExecutor _threadPoolExecutor;
    private int _workersCoreSize = 2;
    private int _workersMaxSize = 5;

    public BaseAsyncDestination() {
    }

    public BaseAsyncDestination(String name) {
        this(name, 2, 5);
    }

    public BaseAsyncDestination(String name, int workersCoreSize, int workersMaxSize) {
        this.name = name;
        this._workersCoreSize = workersCoreSize;
        this._workersMaxSize = workersMaxSize;
        this.open();
    }

    @Override
    public void close(boolean force) {
        PortalExecutorManagerUtil.shutdown(this.getName(), force);
    }

    @Override
    public DestinationStatistics getDestinationStatistics() {
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        destinationStatistics.setActiveThreadCount(this._threadPoolExecutor.getActiveCount());
        destinationStatistics.setCurrentThreadCount(this._threadPoolExecutor.getPoolSize());
        destinationStatistics.setLargestThreadCount(this._threadPoolExecutor.getLargestPoolSize());
        destinationStatistics.setMaxThreadPoolSize(this._threadPoolExecutor.getMaxPoolSize());
        destinationStatistics.setMinThreadPoolSize(this._threadPoolExecutor.getCorePoolSize());
        destinationStatistics.setPendingMessageCount(this._threadPoolExecutor.getPendingTaskCount());
        destinationStatistics.setSentMessageCount(this._threadPoolExecutor.getCompletedTaskCount());
        return destinationStatistics;
    }

    public int getMaximumQueueSize() {
        return this._maximumQueueSize;
    }

    public int getWorkersCoreSize() {
        return this._workersCoreSize;
    }

    public int getWorkersMaxSize() {
        return this._workersMaxSize;
    }

    @Override
    public void open() {
        if (this._threadPoolExecutor != null && !this._threadPoolExecutor.isShutdown()) {
            return;
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        if (this._rejectedExecutionHandler == null) {
            this._rejectedExecutionHandler = this.createRejectionExecutionHandler();
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this._workersCoreSize, this._workersMaxSize, 60L, TimeUnit.SECONDS, false, this._maximumQueueSize, this._rejectedExecutionHandler, new NamedThreadFactory(this.getName(), 5, classLoader), new ThreadPoolHandlerAdapter());
        ThreadPoolExecutor oldThreadPoolExecutor = PortalExecutorManagerUtil.registerPortalExecutor(this.getName(), threadPoolExecutor);
        if (oldThreadPoolExecutor != null) {
            if (_log.isWarnEnabled()) {
                _log.warn("Abort creating a new thread pool for destination " + this.getName() + " and reuse previous one");
            }
            threadPoolExecutor.shutdownNow();
            threadPoolExecutor = oldThreadPoolExecutor;
        }
        this._threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public void send(Message message) {
        if (this.messageListeners.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug("No message listeners for destination " + this.getName());
            }
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        if (threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("Destination " + this.getName() + " is shutdown and cannot " + "receive more messages");
        }
        this.populateMessageFromThreadLocals(message);
        this.dispatch(this.messageListeners, message);
    }

    public void setMaximumQueueSize(int maximumQueueSize) {
        this._maximumQueueSize = maximumQueueSize;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this._rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setWorkersCoreSize(int workersCoreSize) {
        this._workersCoreSize = workersCoreSize;
    }

    public void setWorkersMaxSize(int workersMaxSize) {
        this._workersMaxSize = workersMaxSize;
    }

    protected RejectedExecutionHandler createRejectionExecutionHandler() {
        return new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (!_log.isWarnEnabled()) {
                    return;
                }
                MessageRunnable messageRunnable = (MessageRunnable)runnable;
                _log.warn("Discarding message " + messageRunnable.getMessage() + " because it exceeds the maximum queue size of " + BaseAsyncDestination.this._maximumQueueSize);
            }
        };
    }

    protected abstract void dispatch(Set<MessageListener> var1, Message var2);

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this._threadPoolExecutor;
    }

    protected void populateMessageFromThreadLocals(Message message) {
        if (!message.contains("companyId")) {
            message.put("companyId", CompanyThreadLocal.getCompanyId());
        }
        if (!message.contains("permissionChecker")) {
            message.put("permissionChecker", PermissionThreadLocal.getPermissionChecker());
        }
        if (!message.contains("principalName")) {
            message.put("principalName", PrincipalThreadLocal.getName());
        }
        if (!message.contains("principalPassword")) {
            message.put("principalPassword", PrincipalThreadLocal.getPassword());
        }
    }

    protected void populateThreadLocalsFromMessage(Message message) {
        Boolean clusterForwardMessage;
        String principalPassword;
        long companyId = message.getLong("companyId");
        if (companyId > 0L) {
            CompanyThreadLocal.setCompanyId(companyId);
        }
        PermissionChecker permissionChecker = (PermissionChecker)message.get("permissionChecker");
        String principalName = message.getString("principalName");
        if (Validator.isNotNull(principalName)) {
            PrincipalThreadLocal.setName(principalName);
        }
        if (permissionChecker == null && Validator.isNotNull(principalName)) {
            try {
                User user = UserLocalServiceUtil.fetchUser(PrincipalThreadLocal.getUserId());
                permissionChecker = PermissionCheckerFactoryUtil.create(user);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (permissionChecker != null) {
            PermissionThreadLocal.setPermissionChecker(permissionChecker);
        }
        if (Validator.isNotNull(principalPassword = message.getString("principalPassword"))) {
            PrincipalThreadLocal.setPassword(principalPassword);
        }
        if ((clusterForwardMessage = (Boolean)message.get("CLUSTER_FORWARD_MESSAGE")) != null) {
            MessageValuesThreadLocal.setValue("CLUSTER_FORWARD_MESSAGE", clusterForwardMessage);
        }
    }
}

