/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.Header;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HeaderCacheServletResponse
extends HttpServletResponseWrapper {
    private boolean _committed;
    private String _contentType;
    private Map<String, List<Header>> _headers = new HashMap<String, List<Header>>();
    private int _status = 200;

    public HeaderCacheServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void addCookie(Cookie cookie) {
        List<Header> values = this._headers.get("cookies");
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put("cookies", values);
        }
        Header header = new Header();
        header.setCookieValue(cookie);
        header.setType(4);
        if (values.contains(header)) {
            return;
        }
        values.add(header);
        super.addCookie(cookie);
    }

    public void addDateHeader(String name, long value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setDateValue(value);
        header.setType(2);
        if (values.contains(header)) {
            return;
        }
        values.add(header);
        super.addDateHeader(name, value);
    }

    public void addHeader(String name, String value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setStringValue(value);
        header.setType(3);
        if (values.contains(header)) {
            return;
        }
        values.add(header);
        if (name.equals("Content-Type")) {
            this.setContentType(value);
        }
        super.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        List<Header> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<Header>();
            this._headers.put(name, values);
        }
        Header header = new Header();
        header.setIntValue(value);
        header.setType(1);
        if (values.contains(header)) {
            return;
        }
        values.add(header);
        super.addIntHeader(name, value);
    }

    public void flushBuffer() {
        this._committed = true;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getHeader(String name) {
        List<Header> values = this._headers.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        Header header = values.get(0);
        return header.toString();
    }

    public Map<String, List<Header>> getHeaders() {
        return this._headers;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isCommitted() {
        return this._committed;
    }

    public void sendError(int status) throws IOException {
        this._status = status;
        super.sendError(status);
    }

    public void sendError(int status, String msg) throws IOException {
        this._status = status;
        super.sendError(status, msg);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        super.sendRedirect(location);
        this.setStatus(301);
    }

    public void setContentLength(int contentLength) {
    }

    public void setContentType(String contentType) {
        if (contentType != null) {
            this._contentType = contentType;
            super.setContentType(contentType);
        }
    }

    public void setDateHeader(String name, long value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setDateValue(value);
        header.setType(2);
        values.add(header);
        super.setDateHeader(name, value);
    }

    public void setHeader(String name, String value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setStringValue(value);
        header.setType(3);
        values.add(header);
        if (name.equals("Content-Type")) {
            this.setContentType(value);
        }
        super.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        ArrayList<Header> values = new ArrayList<Header>();
        this._headers.put(name, values);
        Header header = new Header();
        header.setIntValue(value);
        header.setType(1);
        values.add(header);
        super.setIntHeader(name, value);
    }

    public void setStatus(int status) {
        this._status = status;
        super.setStatus(status);
    }
}

