/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.ByteBufferServletResponse;
import com.liferay.portal.kernel.servlet.Range;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.RandomAccessInputStream;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletResponseUtil {
    private static final String _CLIENT_ABORT_EXCEPTION = "org.apache.catalina.connector.ClientAbortException";
    private static final int _MAX_RANGE_FIELDS = GetterUtil.getInteger(PropsUtil.get("web.server.servlet.max.range.fields"));
    private static final String _RANGE_REGEX = "^bytes=\\d*-\\d*(,\\s?\\d*-\\d*)*$";
    private static Log _log = LogFactoryUtil.getLog(ServletResponseUtil.class);

    public static List<Range> getRanges(HttpServletRequest request, HttpServletResponse response, long length) throws IOException {
        String rangeString = request.getHeader("Range");
        if (Validator.isNull(rangeString)) {
            return Collections.emptyList();
        }
        if (!rangeString.matches(_RANGE_REGEX)) {
            throw new IOException("Range header does not match regular expression " + rangeString);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        String[] rangeFields = StringUtil.split(rangeString.substring(6));
        if (rangeFields.length > _MAX_RANGE_FIELDS) {
            StringBundler sb = new StringBundler(8);
            sb.append("Request range ");
            sb.append(rangeString);
            sb.append(" with ");
            sb.append(rangeFields.length);
            sb.append(" range fields has exceeded maximum allowance as ");
            sb.append("specified by the property \"");
            sb.append("web.server.servlet.max.range.fields");
            sb.append("\"");
            throw new IOException(sb.toString());
        }
        String[] stringArray = rangeFields;
        int n = rangeFields.length;
        int n2 = 0;
        while (n2 < n) {
            String rangeField = stringArray[n2];
            int index = rangeField.indexOf("-");
            long start = GetterUtil.getLong(rangeField.substring(0, index), -1L);
            long end = GetterUtil.getLong(rangeField.substring(index + 1, rangeField.length()), -1L);
            if (start == -1L) {
                start = length - end;
                end = length - 1L;
            } else if (end == -1L || end > length - 1L) {
                end = length - 1L;
            }
            if (start > end) {
                throw new IOException("Range start " + start + " is greater than end " + end);
            }
            Range range = new Range(start, end, length);
            ranges.add(range);
            ++n2;
        }
        return ranges;
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] bytes) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, bytes, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] bytes, String contentType) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, bytes, contentType, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] bytes, String contentType, String contentDispositionType) throws IOException {
        ServletResponseUtil.setHeaders(request, response, fileName, contentType, contentDispositionType);
        ServletResponseUtil.write(response, bytes);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, is, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is, long contentLength, String contentType) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, is, 0L, contentType, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is, long contentLength, String contentType, String contentDispositionType) throws IOException {
        ServletResponseUtil.setHeaders(request, response, fileName, contentType, contentDispositionType);
        ServletResponseUtil.write(response, is, contentLength);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is, String contentType) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, is, 0L, contentType);
    }

    public static void sendFile(HttpServletResponse response, String fileName, byte[] bytes) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, bytes);
    }

    public static void sendFile(HttpServletResponse response, String fileName, byte[] bytes, String contentType) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, bytes, contentType);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, is);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is, int contentLength, String contentType) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, is, contentLength, contentType);
    }

    public static void sendFile(HttpServletResponse response, String fileName, InputStream is, String contentType) throws IOException {
        ServletResponseUtil.sendFile(null, response, fileName, is, contentType);
    }

    public static void write(HttpServletRequest request, HttpServletResponse response, String fileName, List<Range> ranges, InputStream inputStream, long fullLength, String contentType) throws IOException {
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            Range fullRange = new Range(0L, fullLength - 1L, fullLength);
            Range firstRange = null;
            if (!ranges.isEmpty()) {
                firstRange = ranges.get(0);
            }
            if (firstRange == null || firstRange.equals(fullRange)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Writing full range");
                }
                response.setContentType(contentType);
                ServletResponseUtil.setHeaders(request, response, fileName, contentType, null, fullRange);
                ServletResponseUtil.copyRange(inputStream, (OutputStream)outputStream, fullRange.getStart(), fullRange.getLength());
            } else if (ranges.size() == 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Attempting to write a single range");
                }
                Range range = ranges.get(0);
                response.setContentType(contentType);
                ServletResponseUtil.setHeaders(request, response, fileName, contentType, null, range);
                response.setStatus(206);
                ServletResponseUtil.copyRange(inputStream, (OutputStream)outputStream, range.getStart(), range.getLength());
            } else if (ranges.size() > 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Attempting to write multiple ranges");
                }
                ServletOutputStream servletOutputStream = outputStream;
                String boundary = "liferay-multipart-boundary-" + System.currentTimeMillis();
                String multipartContentType = "multipart/byteranges; boundary=" + boundary;
                response.setContentType(multipartContentType);
                ServletResponseUtil.setHeaders(request, response, fileName, multipartContentType, null);
                response.setStatus(206);
                int i = 0;
                while (i < ranges.size()) {
                    Range range = ranges.get(i);
                    servletOutputStream.println();
                    servletOutputStream.println("--" + boundary);
                    servletOutputStream.println("Content-Type: " + contentType);
                    servletOutputStream.println("Content-Range: " + range.getContentRange());
                    servletOutputStream.println();
                    ServletResponseUtil.copyRange(inputStream, (OutputStream)outputStream, range.getStart(), range.getLength());
                    ++i;
                }
                servletOutputStream.println();
                servletOutputStream.println("--" + boundary + "--");
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static void write(HttpServletResponse response, byte[] bytes) throws IOException {
        ServletResponseUtil.write(response, bytes, 0, 0);
    }

    public static void write(HttpServletResponse response, byte[] bytes, int offset, int contentLength) throws IOException {
        try {
            if (!response.isCommitted()) {
                if (contentLength == 0) {
                    contentLength = bytes.length;
                }
                response.setContentLength(contentLength);
                response.flushBuffer();
                if (response instanceof ByteBufferServletResponse) {
                    ByteBufferServletResponse byteBufferResponse = (ByteBufferServletResponse)response;
                    byteBufferResponse.setByteBuffer(ByteBuffer.wrap(bytes, offset, contentLength));
                } else {
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    if (contentLength != 0 || !ServerDetector.isJetty()) {
                        servletOutputStream.write(bytes, offset, contentLength);
                    }
                }
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof SocketException || ServletResponseUtil.isClientAbortException(ioe)) {
                if (_log.isWarnEnabled()) {
                    _log.warn(ioe);
                }
            }
            throw ioe;
        }
    }

    public static void write(HttpServletResponse response, byte[][] bytesArray) throws IOException {
        try {
            if (!response.isCommitted()) {
                int contentLength = 0;
                byte[][] byArray = bytesArray;
                int n = bytesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte[] bytes = byArray[n2];
                    contentLength += bytes.length;
                    ++n2;
                }
                response.setContentLength(contentLength);
                response.flushBuffer();
                ServletOutputStream servletOutputStream = response.getOutputStream();
                byte[][] byArray2 = bytesArray;
                int n3 = bytesArray.length;
                n = 0;
                while (n < n3) {
                    byte[] bytes = byArray2[n];
                    servletOutputStream.write(bytes);
                    ++n;
                }
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof SocketException || ServletResponseUtil.isClientAbortException(ioe)) {
                if (_log.isWarnEnabled()) {
                    _log.warn(ioe);
                }
            }
            throw ioe;
        }
    }

    public static void write(HttpServletResponse response, ByteBuffer byteBuffer) throws IOException {
        if (response instanceof ByteBufferServletResponse) {
            ByteBufferServletResponse byteBufferResponse = (ByteBufferServletResponse)response;
            byteBufferResponse.setByteBuffer(byteBuffer);
        } else {
            ServletResponseUtil.write(response, byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        }
    }

    public static void write(HttpServletResponse response, File file) throws IOException {
        if (response instanceof ByteBufferServletResponse) {
            ByteBufferServletResponse byteBufferResponse = (ByteBufferServletResponse)response;
            ByteBuffer byteBuffer = ByteBuffer.wrap(FileUtil.getBytes(file));
            byteBufferResponse.setByteBuffer(byteBuffer);
        } else if (response instanceof StringServletResponse) {
            StringServletResponse stringResponse = (StringServletResponse)response;
            String s = FileUtil.read(file);
            stringResponse.setString(s);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            try {
                int contentLength = (int)fileChannel.size();
                response.setContentLength(contentLength);
                response.flushBuffer();
                fileChannel.transferTo(0L, contentLength, Channels.newChannel((OutputStream)response.getOutputStream()));
            }
            finally {
                fileChannel.close();
            }
        }
    }

    public static void write(HttpServletResponse response, InputStream is) throws IOException {
        ServletResponseUtil.write(response, is, 0L);
    }

    public static void write(HttpServletResponse response, InputStream is, long contentLength) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        if (contentLength > 0L) {
            response.setHeader("Content-Length", String.valueOf(contentLength));
        }
        response.flushBuffer();
        StreamUtil.transfer(is, (OutputStream)response.getOutputStream());
    }

    public static void write(HttpServletResponse response, String s) throws IOException {
        if (response instanceof StringServletResponse) {
            StringServletResponse stringResponse = (StringServletResponse)response;
            stringResponse.setString(s);
        } else {
            ByteBuffer byteBuffer = CharsetEncoderUtil.encode("UTF-8", s);
            ServletResponseUtil.write(response, byteBuffer);
        }
    }

    public static void write(HttpServletResponse response, StringServletResponse stringResponse) throws IOException {
        if (stringResponse.isCalledGetOutputStream()) {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = stringResponse.getUnsyncByteArrayOutputStream();
            ByteBuffer byteBuffer = unsyncByteArrayOutputStream.unsafeGetByteBuffer();
            ServletResponseUtil.write(response, byteBuffer);
        } else {
            ServletResponseUtil.write(response, stringResponse.getString());
        }
    }

    protected static void copyRange(InputStream inputStream, OutputStream outputStream, long start, long length) throws IOException {
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel fileChannel = fileInputStream.getChannel();
            fileChannel.transferTo(start, length, Channels.newChannel(outputStream));
        } else if (inputStream instanceof ByteArrayInputStream) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
            byteArrayInputStream.skip(start);
            StreamUtil.transfer((InputStream)byteArrayInputStream, outputStream, length);
        } else {
            RandomAccessInputStream randomAccessInputStream = new RandomAccessInputStream(inputStream);
            randomAccessInputStream.seek(start);
            StreamUtil.transfer((InputStream)randomAccessInputStream, outputStream, length);
        }
    }

    protected static boolean isClientAbortException(IOException ioe) {
        Class<?> clazz = ioe.getClass();
        String className = clazz.getName();
        return className.equals(_CLIENT_ABORT_EXCEPTION);
    }

    protected static void setHeaders(HttpServletRequest request, HttpServletResponse response, String fileName, String contentType, String contentDispositionType) {
        if (_log.isDebugEnabled()) {
            _log.debug("Sending file of type " + contentType);
        }
        if (Validator.isNotNull(contentType)) {
            response.setContentType(contentType);
        }
        if (!response.containsHeader("Cache-Control")) {
            response.setHeader("Cache-Control", "private");
        }
        if (Validator.isNull(fileName)) {
            return;
        }
        String contentDispositionFileName = "filename=\"" + fileName + "\"";
        boolean ascii = true;
        int i = 0;
        while (i < fileName.length()) {
            if (!Validator.isAscii(fileName.charAt(i))) {
                ascii = false;
                break;
            }
            ++i;
        }
        if (!ascii) {
            String encodedFileName = HttpUtil.encodeURL(fileName, true);
            contentDispositionFileName = BrowserSnifferUtil.isIe(request) ? "filename=\"" + encodedFileName + "\"" : "filename*=UTF-8''" + encodedFileName;
        }
        if (Validator.isNull(contentDispositionType)) {
            String extension = GetterUtil.getString(FileUtil.getExtension(fileName)).toLowerCase();
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray("mime.types.content.disposition.inline");
            }
            catch (Exception exception) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            contentDispositionType = ArrayUtil.contains(mimeTypesContentDispositionInline, extension) ? "inline" : "attachment";
        }
        StringBundler sb = new StringBundler(4);
        sb.append(contentDispositionType);
        sb.append(";");
        sb.append(" ");
        sb.append(contentDispositionFileName);
        if (_log.isDebugEnabled()) {
            _log.debug("Setting content disposition header " + sb.toString());
        }
        response.setHeader("Content-Disposition", sb.toString());
    }

    protected static void setHeaders(HttpServletRequest request, HttpServletResponse response, String fileName, String contentType, String contentDispositionType, Range range) {
        ServletResponseUtil.setHeaders(request, response, fileName, contentType, contentDispositionType);
        if (range != null) {
            response.setHeader("Content-Range", range.getContentRange());
            response.setHeader("Content-Length", String.valueOf(range.getLength()));
        }
    }
}

