/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.HeaderCacheServletResponse;
import com.liferay.portal.kernel.servlet.PipingServletOutputStream;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class StringServletResponse
extends HeaderCacheServletResponse {
    private static Log _log = LogFactoryUtil.getLog(StringServletResponse.class);
    private int _bufferSize;
    private boolean _calledGetOutputStream;
    private boolean _calledGetWriter;
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;
    private String _string;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;
    private UnsyncStringWriter _unsyncStringWriter;

    public StringServletResponse(HttpServletResponse response) {
        super(response);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public ServletOutputStream getOutputStream() {
        if (this._calledGetWriter) {
            throw new IllegalStateException("Cannot obtain OutputStream because Writer is already in use");
        }
        if (this._servletOutputStream == null) {
            this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            this._servletOutputStream = new PipingServletOutputStream(this._unsyncByteArrayOutputStream);
        }
        this._calledGetOutputStream = true;
        return this._servletOutputStream;
    }

    public String getString() {
        if (this._string != null) {
            return this._string;
        }
        if (this._calledGetOutputStream) {
            try {
                this._string = this._unsyncByteArrayOutputStream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                _log.error(uee, uee);
                this._string = "";
            }
        } else {
            this._string = this._calledGetWriter ? this._unsyncStringWriter.toString() : "";
        }
        return this._string;
    }

    public UnsyncByteArrayOutputStream getUnsyncByteArrayOutputStream() {
        return this._unsyncByteArrayOutputStream;
    }

    public PrintWriter getWriter() {
        if (this._calledGetOutputStream) {
            throw new IllegalStateException("Cannot obtain Writer because OutputStream is already in use");
        }
        if (this._printWriter == null) {
            this._unsyncStringWriter = new UnsyncStringWriter();
            this._printWriter = UnsyncPrintWriterPool.borrow(this._unsyncStringWriter);
        }
        this._calledGetWriter = true;
        return this._printWriter;
    }

    public boolean isCalledGetOutputStream() {
        return this._calledGetOutputStream;
    }

    public boolean isCalledGetWriter() {
        return this._calledGetWriter;
    }

    public void recycle() {
        this._string = null;
        this.setStatus(200);
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this._calledGetOutputStream) {
            this._calledGetOutputStream = false;
            this._unsyncByteArrayOutputStream.reset();
        } else if (this._calledGetWriter) {
            this._calledGetWriter = false;
            this._unsyncStringWriter.reset();
        }
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setLocale(Locale locale) {
    }

    public void setString(String string) {
        this._string = string;
    }

    public void writeTo(Writer writer) throws IOException {
        if (this._string != null) {
            writer.write(this._string);
        } else if (this._calledGetWriter) {
            StringBundler sb = this._unsyncStringWriter.getStringBundler();
            sb.writeTo(writer);
        } else {
            writer.write(this.getString());
        }
    }
}

