/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JDKLoggerTestUtil {
    static {
        LogFactoryUtil.getLog(JDKLoggerTestUtil.class);
    }

    public static List<LogRecord> configureJDKLogger(String name, Level level) {
        Logger logger = Logger.getLogger(name);
        Handler[] handlerArray = logger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            logger.removeHandler(handler);
            ++n2;
        }
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        CaptureHandler captureHandler = new CaptureHandler();
        logger.addHandler(captureHandler);
        return captureHandler._logRecords;
    }

    private static class CaptureHandler
    extends Handler {
        private List<LogRecord> _logRecords = new CopyOnWriteArrayList<LogRecord>();

        private CaptureHandler() {
        }

        @Override
        public void close() throws SecurityException {
            this._logRecords.clear();
        }

        @Override
        public void flush() {
            this._logRecords.clear();
        }

        @Override
        public boolean isLoggable(LogRecord logRecord) {
            return false;
        }

        @Override
        public void publish(LogRecord logRecord) {
            this._logRecords.add(logRecord);
        }
    }
}

