/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.plugins;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.test.plugins.LiferayPluginsIntegrationJUnitRunner;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;

public class PluginIntegrationTestHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(PluginIntegrationTestHotDeployListener.class);

    @Override
    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Unable to register tests for ", t);
        }
    }

    @Override
    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Unable to register tests for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<Class<?>> testClasses = this.getAllClassesInIntegrationJar(hotDeployEvent);
        this.runTestClasses(testClasses);
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        _log.debug("Undeploying tests for " + hotDeployEvent);
    }

    protected List<Class<?>> getAllClassesInIntegrationJar(HotDeployEvent hotDeployEvent) throws ClassNotFoundException {
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        URL url = classLoader.getResource("../lib");
        File file = new File(url.getFile(), String.valueOf(hotDeployEvent.getServletContextName()) + "-test-integration.jar");
        if (!file.exists()) {
            return Collections.emptyList();
        }
        ArrayList classes = new ArrayList();
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader(file);
        List<String> entries = zipReader.getEntries();
        for (String entry : entries) {
            if (!entry.endsWith(".class")) continue;
            String className = entry.replace("/", ".");
            className = className.substring(0, className.indexOf(".class"));
            Class<?> clazz = classLoader.loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    protected boolean isTestClass(Class<?> clazz) {
        Class<?> declaringClass = ReflectionUtil.getAnnotationDeclaringClass(RunWith.class, clazz);
        if (declaringClass == null) {
            return false;
        }
        RunWith runWith = declaringClass.getAnnotation(RunWith.class);
        Class value = runWith.value();
        String className = clazz.getName();
        return className.endsWith("Test") && value.equals(LiferayPluginsIntegrationJUnitRunner.class);
    }

    protected void runTestClasses(List<Class<?>> classes) throws RuntimeException {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        for (Class<?> clazz : classes) {
            if (!this.isTestClass(clazz)) continue;
            double startTime = System.currentTimeMillis();
            if (_log.isInfoEnabled()) {
                _log.info("Running " + clazz.getName());
            }
            Result result = JUnitCore.runClasses((Class[])new Class[]{clazz});
            if (_log.isInfoEnabled()) {
                double endTime = System.currentTimeMillis();
                StringBundler sb = new StringBundler(9);
                sb.append("Tests run: ");
                sb.append(result.getRunCount());
                sb.append(", Failures: ");
                sb.append(result.getIgnoreCount());
                sb.append(", Errors: ");
                sb.append(result.getFailureCount());
                sb.append(", Time elapsed: ");
                sb.append(numberFormat.format((endTime - startTime) / 1000.0));
                sb.append(" sec");
                _log.info(sb.toString());
            }
            for (Failure failure : result.getFailures()) {
                _log.error(failure.toString());
            }
        }
    }
}

