/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapUtil {
    private static Log _log = LogFactoryUtil.getLog(MapUtil.class);

    public static <K, V> void copy(Map<K, V> master, Map<? super K, ? super V> copy) {
        copy.clear();
        MapUtil.merge(master, copy);
    }

    public static boolean getBoolean(Map<String, ?> map, String key) {
        return MapUtil.getBoolean(map, key, false);
    }

    public static boolean getBoolean(Map<String, ?> map, String key, boolean defaultValue) {
        return GetterUtil.getBoolean(MapUtil.getString(map, key, String.valueOf(defaultValue)), defaultValue);
    }

    public static double getDouble(Map<String, ?> map, String key) {
        return MapUtil.getDouble(map, key, 0.0);
    }

    public static double getDouble(Map<String, ?> map, String key, double defaultValue) {
        return GetterUtil.getDouble(MapUtil.getString(map, key, String.valueOf(defaultValue)), defaultValue);
    }

    public static int getInteger(Map<String, ?> map, String key) {
        return MapUtil.getInteger(map, key, 0);
    }

    public static int getInteger(Map<String, ?> map, String key, int defaultValue) {
        return GetterUtil.getInteger(MapUtil.getString(map, key, String.valueOf(defaultValue)), defaultValue);
    }

    public static long getLong(Map<Long, Long> map, long key) {
        return MapUtil.getLong(map, key, 0L);
    }

    public static long getLong(Map<Long, Long> map, long key, long defaultValue) {
        Long value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static long getLong(Map<String, ?> map, String key) {
        return MapUtil.getLong(map, key, 0L);
    }

    public static long getLong(Map<String, ?> map, String key, long defaultValue) {
        return GetterUtil.getLong(MapUtil.getString(map, key, String.valueOf(defaultValue)), defaultValue);
    }

    public static short getShort(Map<String, ?> map, String key) {
        return MapUtil.getShort(map, key, (short)0);
    }

    public static short getShort(Map<String, ?> map, String key, short defaultValue) {
        return GetterUtil.getShort(MapUtil.getString(map, key, String.valueOf(defaultValue)), defaultValue);
    }

    public static String getString(Map<String, ?> map, String key) {
        return MapUtil.getString(map, key, "");
    }

    public static String getString(Map<String, ?> map, String key, String defaultValue) {
        Object value = map.get(key);
        if (value != null) {
            if (value instanceof String[]) {
                String[] array = (String[])value;
                if (array.length > 0) {
                    return GetterUtil.getString(array[0], defaultValue);
                }
            } else {
                if (value instanceof String) {
                    return GetterUtil.getString((String)value, defaultValue);
                }
                return GetterUtil.getString(String.valueOf(value), defaultValue);
            }
        }
        return defaultValue;
    }

    public static <K, V> void merge(Map<K, V> master, Map<? super K, ? super V> copy) {
        copy.putAll(master);
    }

    public static <T> LinkedHashMap<String, T> toLinkedHashMap(String[] params) {
        return MapUtil.toLinkedHashMap(params, ":");
    }

    public static <T> LinkedHashMap<String, T> toLinkedHashMap(String[] params, String delimiter) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] kvp = StringUtil.split(param, delimiter);
            if (kvp.length == 2) {
                map.put(kvp[0], kvp[1]);
            } else if (kvp.length == 3) {
                String type = kvp[2];
                if (type.equalsIgnoreCase("boolean") || type.equals(Boolean.class.getName())) {
                    map.put(kvp[0], Boolean.valueOf(kvp[1]));
                } else if (type.equalsIgnoreCase("double") || type.equals(Double.class.getName())) {
                    map.put(kvp[0], new Double(kvp[1]));
                } else if (type.equalsIgnoreCase("int") || type.equals(Integer.class.getName())) {
                    map.put(kvp[0], new Integer(kvp[1]));
                } else if (type.equalsIgnoreCase("long") || type.equals(Long.class.getName())) {
                    map.put(kvp[0], new Long(kvp[1]));
                } else if (type.equalsIgnoreCase("short") || type.equals(Short.class.getName())) {
                    map.put(kvp[0], new Short(kvp[1]));
                } else if (type.equals(String.class.getName())) {
                    map.put(kvp[0], kvp[1]);
                } else {
                    try {
                        Class<?> clazz = Class.forName(type);
                        Constructor<?> constructor = clazz.getConstructor(String.class);
                        map.put(kvp[0], constructor.newInstance(kvp[1]));
                    }
                    catch (Exception e) {
                        _log.error(e.getMessage(), e);
                    }
                }
            }
            ++n2;
        }
        return map;
    }

    public static String toString(Map<?, ?> map) {
        return MapUtil.toString(map, null, null);
    }

    public static String toString(Map<?, ?> map, String hideIncludesRegex, String hideExcludesRegex) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        StringBundler sb = new StringBundler(map.size() * 4 + 1);
        sb.append("{");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            String keyString = String.valueOf(key);
            if (hideIncludesRegex != null && !keyString.matches(hideIncludesRegex)) {
                value = "********";
            }
            if (hideExcludesRegex != null && keyString.matches(hideExcludesRegex)) {
                value = "********";
            }
            sb.append(keyString);
            sb.append("=");
            if (value instanceof Map) {
                sb.append(MapUtil.toString((Map)value));
            } else if (value instanceof String[]) {
                String valueString = StringUtil.merge((String[])value, ", ");
                sb.append("[".concat(valueString).concat("]"));
            } else {
                sb.append(value);
            }
            sb.append(", ");
        }
        sb.setStringAt("}", sb.index() - 1);
        return sb.toString();
    }
}

