/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ProgressTracker {
    public static final String PERCENT = String.valueOf(ProgressTracker.class.getName()) + "_PERCENT";
    private PortletRequest _portletRequest;
    private String _progressId;
    private HttpServletRequest _request;

    public ProgressTracker(HttpServletRequest request, String progressId) {
        this._request = request;
        this._progressId = progressId;
    }

    public ProgressTracker(PortletRequest portletRequest, String progressId) {
        this._portletRequest = portletRequest;
        this._progressId = progressId;
    }

    public void finish() {
        if (this._request != null) {
            HttpSession session = this._request.getSession();
            session.removeAttribute(String.valueOf(PERCENT) + this._progressId);
        } else {
            PortletSession portletSession = this._portletRequest.getPortletSession();
            portletSession.removeAttribute(String.valueOf(PERCENT) + this._progressId, 1);
        }
    }

    public int getProgress() {
        if (this._request != null) {
            HttpSession session = this._request.getSession();
            return (Integer)session.getAttribute(String.valueOf(PERCENT) + this._progressId);
        }
        PortletSession portletSession = this._portletRequest.getPortletSession();
        return (Integer)portletSession.getAttribute(String.valueOf(PERCENT) + this._progressId);
    }

    public void start() {
        this.updateProgress(1);
    }

    public void updateProgress(int percentage) {
        if (this._request != null) {
            HttpSession session = this._request.getSession();
            session.setAttribute(String.valueOf(PERCENT) + this._progressId, (Object)new Integer(percentage));
        } else {
            PortletSession portletSession = this._portletRequest.getPortletSession();
            portletSession.setAttribute(String.valueOf(PERCENT) + this._progressId, (Object)new Integer(percentage), 1);
        }
    }
}

