/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.memory.EqualityWeakReference;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProxyUtil {
    private static Class<?>[] _argumentsClazz = new Class[]{InvocationHandler.class};
    private static ReferenceQueue<ClassLoader> _classLoaderReferenceQueue = new ReferenceQueue();
    private static ConcurrentMap<EqualityWeakReference<ClassLoader>, ConcurrentMap<LookupKey, Reference<Class<?>>>> _classReferences = new ConcurrentHashMap();
    private static ConcurrentMap<EqualityWeakReference<Class<?>>, Constructor<?>> _constructors = new ConcurrentHashMap();
    private static Field _invocationHandlerField;
    private static ReferenceQueue<Class<?>> _proxyClassReferenceQueue;

    static {
        _proxyClassReferenceQueue = new ReferenceQueue();
        try {
            _invocationHandlerField = ReflectionUtil.getDeclaredField(Proxy.class, "h");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static InvocationHandler getInvocationHandler(Object proxy) {
        if (!ProxyUtil.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("Not a proxy instance");
        }
        try {
            return (InvocationHandler)_invocationHandlerField.get(proxy);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... interfaceClasses) {
        EqualityWeakReference staleProxyClassReference;
        EqualityWeakReference staleClassLoaderReference;
        ConcurrentMap oldClassReferences;
        EqualityWeakReference<ClassLoader> classLoaderReference = new EqualityWeakReference<ClassLoader>(classLoader);
        ConcurrentMap<LookupKey, WeakReference<Class>> classReferences = (ConcurrentHashMap)_classReferences.get(classLoaderReference);
        if (classReferences == null && (oldClassReferences = (ConcurrentMap)_classReferences.putIfAbsent(classLoaderReference = new EqualityWeakReference<ClassLoader>(classLoader, _classLoaderReferenceQueue), classReferences = new ConcurrentHashMap())) != null) {
            classReferences = oldClassReferences;
            classLoaderReference.enqueue();
        }
        LookupKey lookupKey = new LookupKey(interfaceClasses);
        Reference classReference = (Reference)classReferences.get(lookupKey);
        Class clazz = null;
        if (classReference == null || (clazz = (Class)classReference.get()) == null) {
            ConcurrentHashMap concurrentHashMap = classReferences;
            synchronized (concurrentHashMap) {
                classReference = (Reference)classReferences.get(lookupKey);
                if (classReference == null || (clazz = (Class)classReference.get()) == null) {
                    clazz = Proxy.getProxyClass(classLoader, interfaceClasses);
                    classReferences.put(lookupKey, new WeakReference<Class>(clazz));
                }
            }
        }
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(_argumentsClazz);
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
        EqualityWeakReference proxyClassReference = new EqualityWeakReference(clazz, _proxyClassReferenceQueue);
        _constructors.putIfAbsent(proxyClassReference, constructor);
        while ((staleClassLoaderReference = (EqualityWeakReference)_classLoaderReferenceQueue.poll()) != null) {
            _classReferences.remove(staleClassLoaderReference);
        }
        while ((staleProxyClassReference = (EqualityWeakReference)_proxyClassReferenceQueue.poll()) != null) {
            _constructors.remove(staleProxyClassReference);
        }
        return clazz;
    }

    public static boolean isProxyClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        EqualityWeakReference equalityWeakReference = new EqualityWeakReference(clazz);
        return _constructors.containsKey(equalityWeakReference);
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] interfaces, InvocationHandler invocationHandler) {
        Class<?> clazz = ProxyUtil.getProxyClass(classLoader, interfaces);
        EqualityWeakReference proxyClassReference = new EqualityWeakReference(clazz);
        Constructor constructor = (Constructor)_constructors.get(proxyClassReference);
        try {
            return constructor.newInstance(invocationHandler);
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    private static class LookupKey {
        private int _hashCode;
        private final Class<?>[] _interfaces;

        public LookupKey(Class<?>[] interfaces) {
            this._interfaces = interfaces;
            this._hashCode = 1;
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                String name = clazz.getName();
                this._hashCode = HashUtil.hash(this._hashCode, name.hashCode());
                ++n2;
            }
        }

        public boolean equals(Object obj) {
            LookupKey lookupKey = (LookupKey)obj;
            if (this._interfaces.length != lookupKey._interfaces.length) {
                return false;
            }
            int i = 0;
            while (i < this._interfaces.length) {
                if (this._interfaces[i] != lookupKey._interfaces[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            return this._hashCode;
        }
    }
}

