/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SystemProperties {
    public static final String SYSTEM_PROPERTIES_FINAL = "system.properties.final";
    public static final String SYSTEM_PROPERTIES_LOAD = "system.properties.load";
    public static final String TMP_DIR = "java.io.tmpdir";
    private static SystemProperties _instance = new SystemProperties();
    private Map<String, String> _properties;

    public static String get(String key) {
        String value = SystemProperties._instance._properties.get(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static String[] getArray(String key) {
        String value = SystemProperties.get(key);
        if (value == null) {
            return new String[0];
        }
        return StringUtil.split(value);
    }

    public static Properties getProperties() {
        return PropertiesUtil.fromMap(SystemProperties._instance._properties);
    }

    public static void set(String key, String value) {
        System.setProperty(key, value);
        SystemProperties._instance._properties.put(key, value);
    }

    private SystemProperties() {
        InputStream inputStream;
        URL url;
        Properties properties = new Properties();
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        try {
            url = classLoader.getResource("system.properties");
            if (url != null) {
                inputStream = url.openStream();
                properties.load(inputStream);
                inputStream.close();
                System.out.println("Loading " + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            url = classLoader.getResource("system-ext.properties");
            if (url != null) {
                inputStream = url.openStream();
                properties.load(inputStream);
                inputStream.close();
                System.out.println("Loading " + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SystemEnv.setProperties(properties);
        boolean systemPropertiesLoad = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_LOAD), true);
        boolean systemPropertiesFinal = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_FINAL), true);
        if (systemPropertiesLoad) {
            Enumeration<?> enu = properties.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                if (!systemPropertiesFinal && !Validator.isNull(System.getProperty(key))) continue;
                System.setProperty(key, properties.getProperty(key));
            }
        }
        this._properties = new ConcurrentHashMap<String, String>();
        PropertiesUtil.fromProperties(properties, this._properties);
    }
}

