/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileNameException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import java.io.File;
import java.io.InputStream;

public class TempFileUtil {
    public static final String SUFFIX_TEMP_FILE_NAME = "_temp.tmp";
    private static final String _BASE_TEMP_PATHNAME = "liferay_temp/";
    private static final long _COMPANY_ID = 0L;
    private static final long _REPOSITORY_ID = 0L;
    private static final long _USER_ID = 0L;
    private static Log _log = LogFactoryUtil.getLog(TempFileUtil.class);

    public static String addTempFile(long userId, String tempPathName, File file) throws PortalException, SystemException {
        String tempFileName = FileUtil.createTempFileName();
        return TempFileUtil.addTempFile(userId, tempFileName, tempPathName, file);
    }

    public static String addTempFile(long userId, String fileName, String tempPathName, File file) throws PortalException, SystemException {
        String tempFileName = TempFileUtil.getTempFileName(userId, fileName, tempPathName);
        DLStoreUtil.addFile(0L, 0L, tempFileName, file);
        return fileName;
    }

    public static String addTempFile(long userId, String fileName, String tempPathName, InputStream inputStream) throws PortalException, SystemException {
        File file = null;
        if (inputStream instanceof ByteArrayFileInputStream) {
            ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)inputStream;
            file = byteArrayFileInputStream.getFile();
        }
        String tempFileName = TempFileUtil.getTempFileName(userId, fileName, tempPathName);
        if (file != null) {
            DLStoreUtil.addFile(0L, 0L, tempFileName, file);
        } else {
            DLStoreUtil.addFile(0L, 0L, tempFileName, inputStream);
        }
        return fileName;
    }

    public static String addTempFile(String tempPathName, File file) throws PortalException, SystemException {
        return TempFileUtil.addTempFile(0L, tempPathName, file);
    }

    public static String addTempFile(String fileName, String tempPathName, File file) throws PortalException, SystemException {
        return TempFileUtil.addTempFile(0L, fileName, tempPathName, file);
    }

    public static void deleteTempFile(long userId, String fileName, String tempPathName) throws PortalException, SystemException {
        String tempFileName = TempFileUtil.getTempFileName(userId, fileName, tempPathName);
        TempFileUtil.deleteTempFile(tempFileName);
    }

    public static void deleteTempFile(String tempFileName) throws PortalException, SystemException {
        DLStoreUtil.deleteFile(0L, 0L, tempFileName);
    }

    public static void deleteTempFile(String fileName, String tempPathName) throws PortalException, SystemException {
        TempFileUtil.deleteTempFile(0L, fileName, tempPathName);
    }

    public static InputStream getTempFileAsStream(String tempFileName) throws PortalException, SystemException {
        return DLStoreUtil.getFileAsStream(0L, 0L, tempFileName);
    }

    public static String[] getTempFileEntryNames(long userId, String tempPathName) {
        try {
            String tempFolderName = TempFileUtil.getTempFolderName(userId, tempPathName);
            String[] fileNames = DLStoreUtil.getFileNames(0L, 0L, tempFolderName);
            int i = 0;
            while (i < fileNames.length) {
                String fileName = StringUtil.extractLast(fileNames[i], "/");
                fileNames[i] = fileName = StringUtil.replace(fileName, SUFFIX_TEMP_FILE_NAME, "");
                ++i;
            }
            return fileNames;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to list temporary file names for " + userId + " in " + tempPathName, e);
            }
            return new String[0];
        }
    }

    public static String[] getTempFileEntryNames(String tempPathName) {
        return TempFileUtil.getTempFileEntryNames(0L, tempPathName);
    }

    public static String getTempFileName(long userId, String fileName, String tempPathName) throws PortalException {
        if (!Validator.isFileName(fileName)) {
            throw new TempFileNameException();
        }
        StringBundler sb = new StringBundler(3);
        sb.append(TempFileUtil.getTempFolderName(userId, tempPathName));
        sb.append(fileName);
        sb.append(SUFFIX_TEMP_FILE_NAME);
        return sb.toString();
    }

    public static long getTempFileSize(String tempFileName) throws PortalException, SystemException {
        return DLStoreUtil.getFileSize(0L, 0L, tempFileName);
    }

    protected static String getTempFolderName(long userId, String tempPathName) throws PortalException {
        if (!Validator.isFilePath(tempPathName, false)) {
            throw new TempFileNameException();
        }
        StringBundler sb = new StringBundler(5);
        sb.append(_BASE_TEMP_PATHNAME);
        sb.append(tempPathName);
        sb.append("/");
        sb.append(userId);
        sb.append("/");
        return sb.toString();
    }
}

