/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webdav;

import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.model.Lock;
import java.io.InputStream;
import java.text.Format;
import java.util.Date;
import java.util.Locale;

public class BaseResourceImpl
implements Resource {
    private static Format _createDateFormatter = FastDateFormatFactoryUtil.getSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private static Format _modifiedDateFormatter = FastDateFormatFactoryUtil.getSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private String _className;
    private Date _createDate;
    private String _displayName;
    private String _href;
    private Object _model;
    private Date _modifiedDate;
    private long _primaryKey = -1L;
    private long _size;

    public BaseResourceImpl(String parentPath, long name, long displayName) {
        this(parentPath, String.valueOf(name), String.valueOf(displayName));
    }

    public BaseResourceImpl(String parentPath, long name, String displayName) {
        this(parentPath, String.valueOf(name), displayName);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName) {
        this(parentPath, name, displayName, null, null);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName, Date createDate, Date modifiedDate) {
        this(parentPath, name, displayName, createDate, modifiedDate, 0L);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName, Date createDate, Date modifiedDate, long size) {
        this._href = parentPath;
        if (Validator.isNotNull(name)) {
            this._href = String.valueOf(this._href) + "/" + name;
        }
        this._href = HttpUtil.encodePath(this._href);
        this._displayName = displayName;
        this._createDate = createDate == null ? new Date() : createDate;
        this._modifiedDate = modifiedDate == null ? new Date() : this._createDate;
        this._size = size;
    }

    @Override
    public String getClassName() {
        return this._className;
    }

    @Override
    public InputStream getContentAsStream() throws WebDAVException {
        return null;
    }

    @Override
    public String getContentType() {
        return "httpd/unix-directory";
    }

    @Override
    public String getCreateDate() {
        return _createDateFormatter.format(this._createDate);
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public String getHREF() {
        return this._href;
    }

    @Override
    public Lock getLock() {
        return null;
    }

    @Override
    public Object getModel() {
        return this._model;
    }

    @Override
    public String getModifiedDate() {
        return _modifiedDateFormatter.format(this._modifiedDate);
    }

    @Override
    public long getPrimaryKey() {
        return this._primaryKey;
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setClassName(String className) {
        this._className = className;
    }

    @Override
    public void setModel(Object model) {
        this._model = model;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        this._primaryKey = primaryKey;
    }
}

