/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionClicks {
    private static final String _DEFAULT_NAMESPACE = SessionClicks.class.getName();
    private static final int _SESSION_CLICKS_MAX_ALLOWED_VALUES = GetterUtil.getInteger(PropsUtil.get("session.clicks.max.allowed.values"));
    private static final int _SESSION_CLICKS_MAX_SIZE_TERMS = GetterUtil.getInteger(PropsUtil.get("session.clicks.max.size.terms"));
    private static Log _log = LogFactoryUtil.getLog(SessionClicks.class);

    public static String get(HttpServletRequest request, String key, String defaultValue) {
        return SessionClicks.get(request, _DEFAULT_NAMESPACE, key, defaultValue);
    }

    public static String get(HttpServletRequest request, String namespace, String key, String defaultValue) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences(request);
            return preferences.getValue(namespace, key, defaultValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            return null;
        }
    }

    public static String get(HttpSession session, String key, String defaultValue) {
        return SessionClicks.get(session, _DEFAULT_NAMESPACE, key, defaultValue);
    }

    public static String get(HttpSession session, String namespace, String key, String defaultValue) {
        String sessionKey = namespace.concat(":").concat(key);
        return GetterUtil.getString(session.getAttribute(sessionKey), defaultValue);
    }

    public static void put(HttpServletRequest request, String key, String value) {
        SessionClicks.put(request, _DEFAULT_NAMESPACE, key, value);
    }

    public static void put(HttpServletRequest request, String namespace, String key, String value) {
        try {
            if (key.length() > _SESSION_CLICKS_MAX_SIZE_TERMS || value.length() > _SESSION_CLICKS_MAX_SIZE_TERMS) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Session clicks has attempted to exceed the maximum size allowed for keys or values with {key=" + key + ", value=" + value + "}");
                }
                return;
            }
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences(request);
            int size = preferences.size();
            if (size <= _SESSION_CLICKS_MAX_ALLOWED_VALUES) {
                preferences.setValue(namespace, key, value);
            } else if (_log.isWarnEnabled()) {
                _log.warn("Session clicks has attempted to exceed the maximum number of allowed values with {key=" + key + ", value=" + value + "}");
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    public static void put(HttpSession session, String key, String value) {
        SessionClicks.put(session, _DEFAULT_NAMESPACE, key, value);
    }

    public static void put(HttpSession session, String namespace, String key, String value) {
        String sessionKey = namespace.concat(":").concat(key);
        session.setAttribute(sessionKey, (Object)value);
    }
}

