/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util.comparator;

import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.journal.model.JournalArticle;

public class ArticleDisplayDateComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "JournalArticle.displayDate ASC, JournalArticle.version ASC";
    public static final String ORDER_BY_DESC = "JournalArticle.displayDate DESC, JournalArticle.version DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"displayDate", "version"};
    private boolean _ascending;

    public ArticleDisplayDateComparator() {
        this(false);
    }

    public ArticleDisplayDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        JournalArticle article1 = (JournalArticle)obj1;
        JournalArticle article2 = (JournalArticle)obj2;
        int value = DateUtil.compareTo(article1.getDisplayDate(), article2.getDisplayDate());
        if (value == 0) {
            if (article1.getVersion() < article2.getVersion()) {
                value = -1;
            } else if (article1.getVersion() > article2.getVersion()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

