/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.ClusterResponseCallback;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ClusterExecutorUtil {
    private static Log _log = LogFactoryUtil.getLog(ClusterExecutorUtil.class);
    private static ClusterExecutor _clusterExecutor;

    public static void addClusterEventListener(ClusterEventListener clusterEventListener) {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return;
        }
        clusterExecutor.addClusterEventListener(clusterEventListener);
    }

    public static void destroy() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return;
        }
        clusterExecutor.destroy();
    }

    public static FutureClusterResponses execute(ClusterRequest clusterRequest) throws SystemException {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return null;
        }
        return clusterExecutor.execute(clusterRequest);
    }

    public static void execute(ClusterRequest clusterRequest, ClusterResponseCallback clusterResponseCallback) throws SystemException {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return;
        }
        clusterExecutor.execute(clusterRequest, clusterResponseCallback);
    }

    public static void execute(ClusterRequest clusterRequest, ClusterResponseCallback clusterResponseCallback, long timeout, TimeUnit timeUnit) throws SystemException {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return;
        }
        clusterExecutor.execute(clusterRequest, clusterResponseCallback, timeout, timeUnit);
    }

    public static ClusterExecutor getClusterExecutor() {
        PortalRuntimePermission.checkGetBeanProperty(ClusterExecutorUtil.class);
        if (_clusterExecutor == null || !_clusterExecutor.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterExecutorUtil has not been initialized");
            }
            return null;
        }
        return _clusterExecutor;
    }

    public static List<Address> getClusterNodeAddresses() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return Collections.emptyList();
        }
        return clusterExecutor.getClusterNodeAddresses();
    }

    public static List<ClusterNode> getClusterNodes() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return Collections.emptyList();
        }
        return clusterExecutor.getClusterNodes();
    }

    public static ClusterNode getLocalClusterNode() throws SystemException {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return null;
        }
        return clusterExecutor.getLocalClusterNode();
    }

    public static Address getLocalClusterNodeAddress() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return null;
        }
        return clusterExecutor.getLocalClusterNodeAddress();
    }

    public static void initialize() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return;
        }
        clusterExecutor.initialize();
    }

    public static boolean isClusterNodeAlive(Address address) {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return false;
        }
        return clusterExecutor.isClusterNodeAlive(address);
    }

    public static boolean isClusterNodeAlive(String clusterNodeId) {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return false;
        }
        return clusterExecutor.isClusterNodeAlive(clusterNodeId);
    }

    public static boolean isEnabled() {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        return clusterExecutor != null;
    }

    public static void removeClusterEventListener(ClusterEventListener clusterEventListener) {
        ClusterExecutor clusterExecutor = ClusterExecutorUtil.getClusterExecutor();
        if (clusterExecutor == null) {
            return;
        }
        clusterExecutor.removeClusterEventListener(clusterEventListener);
    }

    public void setClusterExecutor(ClusterExecutor clusterExecutor) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _clusterExecutor = clusterExecutor;
    }
}

