/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class RowChecker {
    public static final String ALIGN = "left";
    public static final String ALL_ROW_IDS = "allRowIds";
    public static final int COLSPAN = 1;
    public static final String CSS_CLASS = "";
    public static final String FORM_NAME = "fm";
    public static final String ROW_IDS = "rowIds";
    public static final String VALIGN = "middle";
    private String _align = "left";
    private String _allRowIds;
    private int _colspan = 1;
    private String _cssClass = "";
    private String _formName;
    private PortletResponse _portletResponse;
    private String _rowIds;
    private String _valign = "middle";

    public RowChecker(PortletResponse portletResponse) {
        this._portletResponse = portletResponse;
        this._allRowIds = String.valueOf(this._portletResponse.getNamespace()) + ALL_ROW_IDS;
        this._formName = String.valueOf(this._portletResponse.getNamespace()) + FORM_NAME;
        this._rowIds = String.valueOf(this._portletResponse.getNamespace()) + ROW_IDS;
    }

    public String getAlign() {
        return this._align;
    }

    public String getAllRowIds() {
        return this._allRowIds;
    }

    public String getAllRowsCheckBox() {
        return this.getAllRowsCheckbox(this._allRowIds, StringUtil.quote(this._rowIds));
    }

    public String getAllRowsId() {
        return this.getAllRowIds();
    }

    public int getColspan() {
        return this._colspan;
    }

    public String getCssClass() {
        return this._cssClass;
    }

    public String getFormName() {
        return this._formName;
    }

    public String getRowCheckBox(boolean checked, boolean disabled, String primaryKey) {
        return this.getRowCheckBox(null, checked, disabled, primaryKey);
    }

    public String getRowCheckBox(HttpServletRequest request, boolean checked, boolean disabled, String primaryKey) {
        return this.getRowCheckBox(checked, disabled, this._rowIds, primaryKey, StringUtil.quote(this._rowIds), StringUtil.quote(this._allRowIds), CSS_CLASS);
    }

    public String getRowId() {
        return this.getRowIds();
    }

    public String getRowIds() {
        return this._rowIds;
    }

    public String getValign() {
        return this._valign;
    }

    public boolean isChecked(Object obj) {
        return false;
    }

    public boolean isDisabled(Object obj) {
        return false;
    }

    public void setAlign(String align) {
        this._align = align;
    }

    public void setAllRowIds(String allRowIds) {
        this._allRowIds = this.getNamespacedValue(allRowIds);
    }

    public void setColspan(int colspan) {
        this._colspan = colspan;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setFormName(String formName) {
        this._formName = this.getNamespacedValue(formName);
    }

    public void setRowIds(String rowIds) {
        this._rowIds = this.getNamespacedValue(rowIds);
    }

    public void setValign(String valign) {
        this._valign = valign;
    }

    protected String getAllRowsCheckbox(String name, String checkBoxRowIds) {
        if (Validator.isNull(name)) {
            return CSS_CLASS;
        }
        StringBuilder sb = new StringBuilder(9);
        sb.append("<input name=\"");
        sb.append(name);
        sb.append("\" type=\"checkbox\" ");
        sb.append("onClick=\"Liferay.Util.checkAll(");
        sb.append("AUI().one(this).ancestor('");
        sb.append(".table'), ");
        sb.append(checkBoxRowIds);
        sb.append(", this, 'tr:not(.lfr-template)'");
        sb.append(");\">");
        return sb.toString();
    }

    protected String getNamespacedValue(String value) {
        if (Validator.isNull(value)) {
            return CSS_CLASS;
        }
        if (!value.startsWith(this._portletResponse.getNamespace())) {
            value = String.valueOf(this._portletResponse.getNamespace()) + value;
        }
        return value;
    }

    protected String getRowCheckBox(boolean checked, boolean disabled, String name, String value, String checkBoxRowIds, String checkBoxAllRowIds, String checkBoxPostOnClick) {
        StringBundler sb = new StringBundler();
        sb.append("<input ");
        if (checked) {
            sb.append("checked ");
        }
        if (disabled) {
            sb.append("disabled ");
        }
        sb.append("name=\"");
        sb.append(name);
        sb.append("\" type=\"checkbox\" value=\"");
        sb.append(value);
        sb.append("\" ");
        if (Validator.isNotNull(this._allRowIds)) {
            sb.append("onClick=\"Liferay.Util.checkAllBox(");
            sb.append("AUI().one(this).ancestor('");
            sb.append(".table'), ");
            sb.append(checkBoxRowIds);
            sb.append(", ");
            sb.append(checkBoxAllRowIds);
            sb.append(");");
            sb.append("AUI().one(this).ancestor('tr:not(.lfr-template)').");
            sb.append("toggleClass('info');");
            if (Validator.isNotNull(checkBoxPostOnClick)) {
                sb.append(checkBoxPostOnClick);
            }
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }
}

