/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

public class SanitizedServletResponse
extends HttpServletResponseWrapper {
    private static final String _DISABLE_XSS_AUDITOR = String.valueOf(SanitizedServletResponse.class.getName()) + "DISABLE_XSS_AUDITOR";
    private static final boolean _X_CONTENT_TYPE_OPTIONS = GetterUtil.getBoolean(PropsUtil.get("http.header.secure.x.content.type.options"), true);
    private static final String[] _X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES = PropsUtil.getArray("http.header.secure.x.content.type.options.urls.excludes");
    private static final boolean _X_FRAME_OPTIONS;
    private static final String _X_XSS_PROTECTION;
    private static final KeyValuePair[] _xFrameOptionKVPs;

    static {
        _X_XSS_PROTECTION = PropsUtil.get("http.header.secure.x.xss.protection");
        SortedProperties properties = new SortedProperties(new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                return GetterUtil.getIntegerStrict(key1) - GetterUtil.getIntegerStrict(key2);
            }
        }, PropsUtil.getProperties("http.header.secure.x.frame.options.", true));
        ArrayList<KeyValuePair> xFrameOptionKVPs = new ArrayList<KeyValuePair>(properties.size());
        for (Map.Entry<Object, Object> entry : ((Properties)properties).entrySet()) {
            String url;
            String propertyValue = (String)entry.getValue();
            String[] propertyValueParts = StringUtil.split(propertyValue, '|');
            if (propertyValueParts.length > 2 || Validator.isNull(url = StringUtil.trim(propertyValueParts[0]))) continue;
            if (propertyValueParts.length == 1) {
                xFrameOptionKVPs.add(new KeyValuePair(url, null));
                continue;
            }
            String value = StringUtil.trim(propertyValueParts[1]);
            if (Validator.isNull(value)) {
                value = null;
            }
            xFrameOptionKVPs.add(new KeyValuePair(url, value));
        }
        _xFrameOptionKVPs = xFrameOptionKVPs.toArray(new KeyValuePair[xFrameOptionKVPs.size()]);
        _X_FRAME_OPTIONS = _xFrameOptionKVPs.length == 0 ? false : GetterUtil.getBoolean(PropsUtil.get("http.header.secure.x.frame.options"), true);
    }

    public static void disableXSSAuditor(HttpServletResponse response) {
        response.setHeader("X-XSS-Protection", "0");
    }

    public static void disableXSSAuditor(PortletResponse portletResponse) {
        SanitizedServletResponse.disableXSSAuditor(PortalUtil.getHttpServletResponse(portletResponse));
    }

    public static void disableXSSAuditorOnNextRequest(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setAttribute(_DISABLE_XSS_AUDITOR, (Object)Boolean.TRUE);
    }

    public static void disableXSSAuditorOnNextRequest(PortletRequest portletRequest) {
        SanitizedServletResponse.disableXSSAuditorOnNextRequest(PortalUtil.getHttpServletRequest(portletRequest));
    }

    public static HttpServletResponse getSanitizedServletResponse(HttpServletRequest request, HttpServletResponse response) {
        SanitizedServletResponse.setXContentOptions(request, response);
        SanitizedServletResponse.setXFrameOptions(request, response);
        SanitizedServletResponse.setXXSSProtection(request, response);
        if (ServerDetector.isResin()) {
            response = new SanitizedServletResponse((HttpServletResponse)response);
        }
        return response;
    }

    public void addHeader(String name, String value) {
        super.addHeader(HttpUtil.sanitizeHeader(name), HttpUtil.sanitizeHeader(value));
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(HttpUtil.sanitizeHeader(location));
    }

    public void setCharacterEncoding(String charset) {
        super.setCharacterEncoding(HttpUtil.sanitizeHeader(charset));
    }

    public void setContentType(String type) {
        super.setContentType(HttpUtil.sanitizeHeader(type));
    }

    public void setHeader(String name, String value) {
        super.setHeader(HttpUtil.sanitizeHeader(name), HttpUtil.sanitizeHeader(value));
    }

    protected static void setXContentOptions(HttpServletRequest request, HttpServletResponse response) {
        if (!_X_CONTENT_TYPE_OPTIONS) {
            return;
        }
        if (_X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES.length > 0) {
            String requestURI = request.getRequestURI();
            String[] stringArray = _X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES;
            int n = _X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                if (requestURI.startsWith(url)) {
                    return;
                }
                ++n2;
            }
        }
        response.setHeader("X-Content-Type-Options", "nosniff");
    }

    protected static void setXFrameOptions(HttpServletRequest request, HttpServletResponse response) {
        if (!_X_FRAME_OPTIONS) {
            return;
        }
        String requestURI = request.getRequestURI();
        KeyValuePair[] keyValuePairArray = _xFrameOptionKVPs;
        int n = _xFrameOptionKVPs.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValuePair xFrameOptionKVP = keyValuePairArray[n2];
            String url = xFrameOptionKVP.getKey();
            String value = xFrameOptionKVP.getValue();
            if (requestURI.startsWith(url)) {
                if (value != null) {
                    response.setHeader("X-Frame-Options", xFrameOptionKVP.getValue());
                }
                return;
            }
            ++n2;
        }
        response.setHeader("X-Frame-Options", "DENY");
    }

    protected static void setXXSSProtection(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute(_DISABLE_XSS_AUDITOR) != null) {
            session.removeAttribute(_DISABLE_XSS_AUDITOR);
            response.setHeader("X-XSS-Protection", "0");
            return;
        }
        if (Validator.isNull(_X_XSS_PROTECTION)) {
            return;
        }
        response.setHeader("X-XSS-Protection", _X_XSS_PROTECTION);
    }

    private SanitizedServletResponse(HttpServletResponse response) {
        super(response);
    }
}

