/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class URLTemplateResource
implements TemplateResource {
    private static Log _log = LogFactoryUtil.getLog(URLTemplateResource.class);
    private String _templateId;
    private URL _templateURL;
    private String _templateURLExternalForm;

    public URLTemplateResource() {
    }

    public URLTemplateResource(String templateId, URL templateURL) {
        if (Validator.isNull(templateId)) {
            throw new IllegalArgumentException("Template ID is null");
        }
        if (templateURL == null) {
            throw new IllegalArgumentException("Template URL is null");
        }
        this._templateId = templateId;
        this._templateURL = templateURL;
        this._templateURLExternalForm = templateURL.toExternalForm();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URLTemplateResource)) {
            return false;
        }
        URLTemplateResource urlTemplateResource = (URLTemplateResource)obj;
        return this._templateId.equals(urlTemplateResource._templateId) && this._templateURLExternalForm.equals(urlTemplateResource._templateURLExternalForm);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long getLastModified() {
        block16: {
            block14: {
                block15: {
                    urlConnection = null;
                    urlConnection = this._templateURL.openConnection();
                    if (!(urlConnection instanceof JarURLConnection)) ** GOTO lbl20
                    jarURLConnection = (JarURLConnection)urlConnection;
                    url = jarURLConnection.getJarFileURL();
                    protocol = url.getProtocol();
                    if (!protocol.equals("file")) break block14;
                    var6_6 = new File(url.getFile()).lastModified();
                    if (urlConnection == null) break block15;
                    try {
                        urlConnection.getInputStream().close();
                    }
                    catch (IOException v0) {}
                }
                return var6_6;
            }
            urlConnection = url.openConnection();
lbl20:
            // 2 sources

            var6_7 = urlConnection.getLastModified();
            if (urlConnection == null) break block16;
            try {
                urlConnection.getInputStream().close();
            }
            catch (IOException v1) {}
        }
        return var6_7;
        catch (IOException ioe) {
            block17: {
                try {
                    URLTemplateResource._log.error("Unable to get last modified time for template " + this._templateId, ioe);
                    if (urlConnection == null) break block17;
                }
                catch (Throwable var5_8) {
                    if (urlConnection != null) {
                        try {
                            urlConnection.getInputStream().close();
                        }
                        catch (IOException v2) {}
                    }
                    throw var5_8;
                }
                try {
                    urlConnection.getInputStream().close();
                }
                catch (IOException v3) {}
            }
            return 0L;
        }
    }

    @Override
    public Reader getReader() throws IOException {
        URLConnection urlConnection = this._templateURL.openConnection();
        return new InputStreamReader(urlConnection.getInputStream(), "UTF-8");
    }

    @Override
    public String getTemplateId() {
        return this._templateId;
    }

    public int hashCode() {
        return this._templateId.hashCode() * 11 + this._templateURLExternalForm.hashCode();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this._templateId = objectInput.readUTF();
        this._templateURLExternalForm = objectInput.readUTF();
        this._templateURL = new URL(this._templateURLExternalForm);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this._templateId);
        objectOutput.writeUTF(this._templateURLExternalForm);
    }
}

