/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CodeCoverageAssertor
implements TestRule {
    private static final Method _assertCoverageMethod;
    private static final Method _dynamicallyInstrumentMethod;
    private final String[] _excludes;
    private final boolean _includeInnerClasses;
    private final String[] _includes;

    static {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> instrumentationAgentClass = systemClassLoader.loadClass("net.sourceforge.cobertura.instrument.InstrumentationAgent");
            _assertCoverageMethod = instrumentationAgentClass.getMethod("assertCoverage", Boolean.TYPE, Class[].class);
            _dynamicallyInstrumentMethod = instrumentationAgentClass.getMethod("dynamicallyInstrument", String[].class, String[].class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public CodeCoverageAssertor() {
        this(null, null, true);
    }

    public CodeCoverageAssertor(String[] includes, String[] excludes, boolean includeInnerClasses) {
        this._includes = includes;
        this._excludes = excludes;
        this._includeInnerClasses = includeInnerClasses;
    }

    public void appendAssertClasses(List<Class<?>> assertClasses) {
    }

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                String[] includes;
                String className = description.getClassName();
                if (className.endsWith("Test")) {
                    className = className.substring(0, className.length() - 4);
                }
                if ((includes = CodeCoverageAssertor.this._includes) == null) {
                    includes = CodeCoverageAssertor.this._generateIncludes(className);
                }
                _dynamicallyInstrumentMethod.invoke(null, includes, CodeCoverageAssertor.this._excludes);
                try {
                    statement.evaluate();
                }
                catch (Throwable throwable) {
                    ArrayList assertClasses = new ArrayList();
                    ClassLoader classLoader = CodeCoverageAssertor.this.getClassLoader();
                    Class<?> clazz = classLoader.loadClass(className);
                    assertClasses.add(clazz);
                    CodeCoverageAssertor.this.appendAssertClasses(assertClasses);
                    _assertCoverageMethod.invoke(null, CodeCoverageAssertor.this._includeInnerClasses, assertClasses.toArray(new Class[assertClasses.size()]));
                    throw throwable;
                }
                ArrayList assertClasses = new ArrayList();
                ClassLoader classLoader = CodeCoverageAssertor.this.getClassLoader();
                Class<?> clazz = classLoader.loadClass(className);
                assertClasses.add(clazz);
                CodeCoverageAssertor.this.appendAssertClasses(assertClasses);
                _assertCoverageMethod.invoke(null, CodeCoverageAssertor.this._includeInnerClasses, assertClasses.toArray(new Class[assertClasses.size()]));
            }
        };
    }

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }

    private String[] _generateIncludes(String mainClassName) throws Exception {
        ArrayList assertClasses = new ArrayList();
        String jvmClassPath = ClassPathUtil.getJVMClassPath(false);
        URL[] urls = ClassPathUtil.getClassPathURLs(jvmClassPath);
        URLClassLoader classLoader = new URLClassLoader(urls, null);
        Class<?> mainClass = classLoader.loadClass(mainClassName);
        assertClasses.add(mainClass);
        if (this._includeInnerClasses) {
            assertClasses.addAll(Arrays.asList(mainClass.getDeclaredClasses()));
        }
        if (this.getClass() != CodeCoverageAssertor.class) {
            Class<?> reloadedClass = classLoader.loadClass(this.getClass().getName());
            Method appendAssertClassesMethod = reloadedClass.getMethod("appendAssertClasses", List.class);
            appendAssertClassesMethod.setAccessible(true);
            Constructor<?> constructor = reloadedClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object reloadedObject = constructor.newInstance(new Object[0]);
            appendAssertClassesMethod.invoke(reloadedObject, assertClasses);
        }
        String[] includes = new String[assertClasses.size()];
        int i = 0;
        while (i < assertClasses.size()) {
            Class assertClass = (Class)assertClasses.get(i);
            includes[i] = StringUtil.replace(assertClass.getName(), new String[]{".", "$"}, new String[]{"/", "\\$"});
            ++i;
        }
        return includes;
    }
}

