/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.portal.kernel.dao.db.BaseDBProcess;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public abstract class UpgradeProcess
extends BaseDBProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeProcess.class);

    public int getThreshold() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasTable(String tableName) throws Exception {
        ResultSet rs;
        Statement ps;
        Connection con;
        block2: {
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                DatabaseMetaData metadata = con.getMetaData();
                rs = metadata.getTables(null, null, tableName, null);
                if (!rs.next()) break block2;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp(con, ps, rs);
            return true;
        }
        DataAccess.cleanUp(con, ps, rs);
        return false;
    }

    public long increment() throws SystemException {
        DB db = DBFactoryUtil.getDB();
        return db.increment();
    }

    public long increment(String name) throws SystemException {
        DB db = DBFactoryUtil.getDB();
        return db.increment(name);
    }

    public boolean isSupportsAlterColumnName() {
        DB db = DBFactoryUtil.getDB();
        return db.isSupportsAlterColumnName();
    }

    public boolean isSupportsAlterColumnType() {
        DB db = DBFactoryUtil.getDB();
        return db.isSupportsAlterColumnType();
    }

    public boolean isSupportsStringCaseSensitiveQuery() {
        DB db = DBFactoryUtil.getDB();
        return db.isSupportsStringCaseSensitiveQuery();
    }

    public boolean isSupportsUpdateWithInnerJoin() {
        DB db = DBFactoryUtil.getDB();
        return db.isSupportsUpdateWithInnerJoin();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tableHasColumn(String tableName, String columnName) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block6: {
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select * from " + tableName);
                rs = ps.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int i = 0;
                while (i < rsmd.getColumnCount()) {
                    String curColumnName = rsmd.getColumnName(i + 1);
                    if (curColumnName.equals(columnName)) break block6;
                    ++i;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(con, ps, rs);
                throw throwable;
            }
            {
                catch (Exception exception) {
                    DataAccess.cleanUp(con, ps, rs);
                    return false;
                    break;
                }
            }
            DataAccess.cleanUp(con, ps, rs);
            return false;
        }
        DataAccess.cleanUp(con, ps, rs);
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tableHasData(String tableName) throws Exception {
        block7: {
            block6: {
                con = null;
                ps = null;
                rs = null;
                try {
                    con = DataAccess.getUpgradeOptimizedConnection();
                    ps = con.prepareStatement("select count(*) from " + tableName);
                    rs = ps.executeQuery();
                    ** GOTO lbl-1000
                    while ((count = rs.getInt(1)) <= 0) lbl-1000:
                    // 2 sources

                    {
                        if (rs.next()) continue;
                        break block6;
                    }
                    break block7;
                }
                catch (Throwable var6_6) {
                    DataAccess.cleanUp(con, ps, rs);
                    throw var6_6;
                }
                {
                    catch (Exception v0) {
                        DataAccess.cleanUp(con, ps, rs);
                        return false;
                        break;
                    }
                }
            }
            DataAccess.cleanUp(con, ps, rs);
            return false;
        }
        DataAccess.cleanUp(con, ps, rs);
        return true;
    }

    public void upgrade() throws UpgradeException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info("Upgrading " + this.getClass().getName());
            }
            this.doUpgrade();
        }
        catch (Exception e) {
            throw new UpgradeException(e);
        }
    }

    public void upgrade(Class<?> upgradeProcessClass) throws UpgradeException {
        UpgradeProcess upgradeProcess = null;
        try {
            upgradeProcess = (UpgradeProcess)upgradeProcessClass.newInstance();
        }
        catch (Exception e) {
            throw new UpgradeException(e);
        }
        upgradeProcess.upgrade();
    }

    public void upgrade(UpgradeProcess upgradeProcess) throws UpgradeException {
        upgradeProcess.upgrade();
    }

    protected void doUpgrade() throws Exception {
    }

    protected void upgradeTable(String tableName, Object[][] tableColumns) throws Exception {
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable(tableName, tableColumns, new UpgradeColumn[0]);
        upgradeTable.updateTable();
    }

    protected void upgradeTable(String tableName, Object[][] tableColumns, String sqlCreate, String[] sqlAddIndexes) throws Exception {
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable(tableName, tableColumns, new UpgradeColumn[0]);
        upgradeTable.setCreateSQL(sqlCreate);
        upgradeTable.setIndexesSQL(sqlAddIndexes);
        upgradeTable.updateTable();
    }
}

