/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.dao.orm;

import com.liferay.portal.kernel.upgrade.dao.orm.UpgradeOptimizedPreparedStatementHandler;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.util.PortalUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class UpgradeOptimizedConnectionHandler
implements InvocationHandler {
    private Connection _connection;
    private boolean _useUpgradeOptimizedPreparedStatementHandler;

    public UpgradeOptimizedConnectionHandler(Connection connection) throws SQLException {
        this._connection = connection;
        DatabaseMetaData metaData = this._connection.getMetaData();
        String productName = metaData.getDatabaseProductName();
        if (productName.equals("Microsoft SQL Server")) {
            this._useUpgradeOptimizedPreparedStatementHandler = true;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            String methodName = method.getName();
            if (methodName.equals("prepareStatement") && arguments.length == 1) {
                return this.prepareStatement((String)arguments[0]);
            }
            return method.invoke((Object)this._connection, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        sql = PortalUtil.transformSQL(sql);
        if (!this._useUpgradeOptimizedPreparedStatementHandler) {
            return this._connection.prepareStatement(sql);
        }
        PreparedStatement preparedStatement = this._connection.prepareStatement(sql, 1005, 1008);
        return (PreparedStatement)ProxyUtil.newProxyInstance(classLoader, new Class[]{PreparedStatement.class}, new UpgradeOptimizedPreparedStatementHandler(preparedStatement));
    }
}

