/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.model.Repository;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class TempFileUtil {
    public static FileEntry addTempFile(long groupId, long userId, String fileName, String tempFolderName, File file, String mimeType) throws PortalException, SystemException {
        Folder folder = TempFileUtil.addTempFolder(groupId, userId, tempFolderName);
        return PortletFileRepositoryUtil.addPortletFileEntry(groupId, userId, "", 0L, "20", folder.getFolderId(), file, fileName, mimeType, false);
    }

    public static FileEntry addTempFile(long groupId, long userId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException, SystemException {
        Folder folder = TempFileUtil.addTempFolder(groupId, userId, tempFolderName);
        return PortletFileRepositoryUtil.addPortletFileEntry(groupId, userId, "", 0L, "20", folder.getFolderId(), inputStream, fileName, mimeType, false);
    }

    public static void deleteTempFile(long fileEntryId) throws PortalException, SystemException {
        PortletFileRepositoryUtil.deletePortletFileEntry(fileEntryId);
    }

    public static void deleteTempFile(long groupId, long userId, String fileName, String tempFolderName) throws PortalException, SystemException {
        Folder folder = TempFileUtil.getTempFolder(groupId, userId, tempFolderName);
        PortletFileRepositoryUtil.deletePortletFileEntry(groupId, folder.getFolderId(), fileName);
    }

    public static FileEntry getTempFile(long groupId, long userId, String fileName, String tempFolderName) throws PortalException, SystemException {
        Folder folder = TempFileUtil.getTempFolder(groupId, userId, tempFolderName);
        return PortletFileRepositoryUtil.getPortletFileEntry(groupId, folder.getFolderId(), fileName);
    }

    public static String[] getTempFileEntryNames(long groupId, long userId, String tempFolderName) throws PortalException, SystemException {
        Folder folder = TempFileUtil.addTempFolder(groupId, userId, tempFolderName);
        List<FileEntry> fileEntries = PortletFileRepositoryUtil.getPortletFileEntries(groupId, folder.getFolderId());
        String[] fileEntryNames = new String[fileEntries.size()];
        int i = 0;
        while (i < fileEntries.size()) {
            FileEntry fileEntry = fileEntries.get(i);
            fileEntryNames[i] = fileEntry.getTitle();
            ++i;
        }
        return fileEntryNames;
    }

    protected static Folder addTempFolder(long groupId, long userId, String tempFolderName) throws PortalException, SystemException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository(groupId, "20", serviceContext);
        Folder userFolder = PortletFileRepositoryUtil.addPortletFolder(userId, repository.getRepositoryId(), 0L, String.valueOf(userId), serviceContext);
        Folder tempFolder = PortletFileRepositoryUtil.addPortletFolder(userId, repository.getRepositoryId(), userFolder.getFolderId(), tempFolderName, serviceContext);
        return tempFolder;
    }

    protected static Folder getTempFolder(long groupId, long userId, String tempFolderName) throws PortalException, SystemException {
        Repository repository = PortletFileRepositoryUtil.getPortletRepository(groupId, "20");
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Folder userFolder = PortletFileRepositoryUtil.getPortletFolder(userId, repository.getRepositoryId(), 0L, String.valueOf(userId), serviceContext);
        Folder tempFolder = PortletFileRepositoryUtil.getPortletFolder(userId, repository.getRepositoryId(), userFolder.getFolderId(), tempFolderName, serviceContext);
        return tempFolder;
    }
}

