/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.mail.model.FileAttachment;
import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.mail.SMTPAccount;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.EscapableObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlEscapableObject;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.SubscriptionPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.InternetAddress;

public class SubscriptionSender
implements Serializable {
    protected String body;
    protected boolean bulk;
    protected long companyId;
    protected List<FileAttachment> fileAttachments = new ArrayList<FileAttachment>();
    protected String fromAddress;
    protected String fromName;
    protected long groupId;
    protected boolean htmlFormat;
    protected String inReplyTo;
    protected Map<Locale, String> localizedBodyMap;
    protected Map<Locale, String> localizedSubjectMap;
    protected String mailId;
    protected String portletId;
    protected String replyToAddress;
    protected long scopeGroupId;
    protected ServiceContext serviceContext;
    protected SMTPAccount smtpAccount;
    protected String subject;
    protected long userId;
    private static Log _log = LogFactoryUtil.getLog(SubscriptionSender.class);
    private List<InternetAddress> _bulkAddresses;
    private transient ClassLoader _classLoader;
    private Map<String, EscapableObject<String>> _context = new HashMap<String, EscapableObject<String>>();
    private String _contextUserPrefix;
    private boolean _initialized;
    private Object[] _mailIdIds;
    private String _mailIdPopPortletPrefix;
    private List<ObjectValuePair<String, Long>> _persistestedSubscribersOVPs = new ArrayList<ObjectValuePair<String, Long>>();
    private List<ObjectValuePair<String, String>> _runtimeSubscribersOVPs = new ArrayList<ObjectValuePair<String, String>>();
    private Set<String> _sentEmailAddresses = new HashSet<String>();

    public void addFileAttachment(File file) {
        this.addFileAttachment(file, null);
    }

    public void addFileAttachment(File file, String fileName) {
        if (file == null) {
            return;
        }
        if (this.fileAttachments == null) {
            this.fileAttachments = new ArrayList<FileAttachment>();
        }
        FileAttachment attachment = new FileAttachment(file, fileName);
        this.fileAttachments.add(attachment);
    }

    public void addPersistedSubscribers(String className, long classPK) {
        ObjectValuePair<String, Long> ovp = new ObjectValuePair<String, Long>(className, classPK);
        this._persistestedSubscribersOVPs.add(ovp);
    }

    public void addRuntimeSubscribers(String toAddress, String toName) {
        ObjectValuePair<String, String> ovp = new ObjectValuePair<String, String>(toAddress, toName);
        this._runtimeSubscribersOVPs.add(ovp);
    }

    public void flushNotifications() throws Exception {
        this.initialize();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            String inferredClassName = null;
            long inferredClassPK = 0L;
            if (this._persistestedSubscribersOVPs.size() > 1) {
                ObjectValuePair<String, Long> objectValuePair = this._persistestedSubscribersOVPs.get(this._persistestedSubscribersOVPs.size() - 1);
                inferredClassName = objectValuePair.getKey();
                inferredClassPK = objectValuePair.getValue();
            }
            for (ObjectValuePair<String, Long> objectValuePair : this._persistestedSubscribersOVPs) {
                String className = objectValuePair.getKey();
                long classPK = objectValuePair.getValue();
                List<Subscription> subscriptions = SubscriptionLocalServiceUtil.getSubscriptions(this.companyId, className, classPK);
                for (Subscription subscription : subscriptions) {
                    try {
                        this.notifySubscriber(subscription, inferredClassName, inferredClassPK);
                    }
                    catch (PortalException portalException) {
                        _log.error("Unable to process subscription: " + subscription);
                    }
                }
                if (!this.bulk) continue;
                Locale locale = LocaleUtil.getDefault();
                InternetAddress to = new InternetAddress(this.replaceContent(this.replyToAddress, locale), this.replaceContent(this.replyToAddress, locale));
                this.sendEmail(to, locale);
            }
            this._persistestedSubscribersOVPs.clear();
            for (ObjectValuePair<String, Object> objectValuePair : this._runtimeSubscribersOVPs) {
                String toAddress = objectValuePair.getKey();
                if (Validator.isNull(toAddress)) continue;
                if (this._sentEmailAddresses.contains(toAddress)) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug("Do not send a duplicate email to " + toAddress);
                    continue;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug("Add " + toAddress + " to the list of users who " + "have received an email");
                }
                this._sentEmailAddresses.add(toAddress);
                String toName = (String)objectValuePair.getValue();
                InternetAddress to = new InternetAddress(toAddress, toName);
                this.sendEmail(to, LocaleUtil.getDefault());
            }
            this._runtimeSubscribersOVPs.clear();
        }
        finally {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void flushNotificationsAsync() {
        Thread currentThread = Thread.currentThread();
        this._classLoader = currentThread.getContextClassLoader();
        MessageBusUtil.sendMessage("liferay/subscription_sender", this);
    }

    public Object getContextAttribute(String key) {
        return this._context.get(key);
    }

    public String getMailId() {
        return this.mailId;
    }

    public void initialize() throws Exception {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        if (this.groupId == 0L && this.serviceContext != null) {
            this.setScopeGroupId(this.serviceContext.getScopeGroupId());
        }
        Company company = CompanyLocalServiceUtil.getCompany(this.companyId);
        this.setContextAttribute("[$COMPANY_ID$]", company.getCompanyId());
        this.setContextAttribute("[$COMPANY_MX$]", company.getMx());
        this.setContextAttribute("[$COMPANY_NAME$]", company.getName());
        this.setContextAttribute("[$PORTAL_URL$]", company.getPortalURL(this.groupId));
        if (this.groupId > 0L) {
            Group group = GroupLocalServiceUtil.getGroup(this.groupId);
            this.setContextAttribute("[$SITE_NAME$]", group.getDescriptiveName());
        }
        if (this.userId > 0L && Validator.isNotNull(this._contextUserPrefix)) {
            this.setContextAttribute("[$" + this._contextUserPrefix + "_USER_ADDRESS$]", PortalUtil.getUserEmailAddress(this.userId));
            this.setContextAttribute("[$" + this._contextUserPrefix + "_USER_NAME$]", PortalUtil.getUserName(this.userId, ""));
        }
        this.mailId = PortalUtil.getMailId(company.getMx(), this._mailIdPopPortletPrefix, this._mailIdIds);
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBulk(boolean bulk) {
        this.bulk = bulk;
    }

    public void setCompanyId(long companyId) {
        this.companyId = companyId;
    }

    public void setContextAttribute(String key, EscapableObject<String> value) {
        this._context.put(key, value);
    }

    public void setContextAttribute(String key, Object value) {
        this.setContextAttribute(key, value, true);
    }

    public void setContextAttribute(String key, Object value, boolean escape) {
        this.setContextAttribute(key, new HtmlEscapableObject<String>(String.valueOf(value), escape));
    }

    public void setContextAttributes(Object ... values) {
        int i = 0;
        while (i < values.length) {
            this.setContextAttribute(String.valueOf(values[i]), values[i + 1]);
            i += 2;
        }
    }

    public void setContextUserPrefix(String contextUserPrefix) {
        this._contextUserPrefix = contextUserPrefix;
    }

    public void setFrom(String fromAddress, String fromName) {
        this.fromAddress = fromAddress;
        this.fromName = fromName;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public void setHtmlFormat(boolean htmlFormat) {
        this.htmlFormat = htmlFormat;
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public void setLocalizedBodyMap(Map<Locale, String> localizedBodyMap) {
        this.localizedBodyMap = localizedBodyMap;
    }

    public void setLocalizedSubjectMap(Map<Locale, String> localizedSubjectMap) {
        this.localizedSubjectMap = localizedSubjectMap;
    }

    public void setMailId(String popPortletPrefix, Object ... ids) {
        this._mailIdPopPortletPrefix = popPortletPrefix;
        this._mailIdIds = ids;
    }

    public void setPortletId(String portletId) {
        this.portletId = portletId;
    }

    public void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    public void setScopeGroupId(long scopeGroupId) {
        try {
            Group group = GroupLocalServiceUtil.getGroup(scopeGroupId);
            this.groupId = group.isLayout() ? group.getParentGroupId() : scopeGroupId;
        }
        catch (Exception exception) {}
        this.scopeGroupId = scopeGroupId;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void setSMTPAccount(SMTPAccount smtpAccount) {
        this.smtpAccount = smtpAccount;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    protected void deleteSubscription(Subscription subscription) throws Exception {
        SubscriptionLocalServiceUtil.deleteSubscription(subscription.getSubscriptionId());
    }

    protected boolean hasPermission(Subscription subscription, String inferredClassName, long inferredClassPK, User user) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
        return SubscriptionPermissionUtil.contains(permissionChecker, subscription.getClassName(), subscription.getClassPK(), inferredClassName, inferredClassPK);
    }

    protected boolean hasPermission(Subscription subscription, User user) throws Exception {
        return this.hasPermission(subscription, null, 0L, user);
    }

    protected void notifySubscriber(Subscription subscription) throws Exception {
        this.notifySubscriber(subscription, null, 0L);
    }

    protected void notifySubscriber(Subscription subscription, String inferredClassName, long inferredClassPK) throws Exception {
        User user = UserLocalServiceUtil.fetchUserById(subscription.getUserId());
        if (user == null) {
            if (_log.isInfoEnabled()) {
                _log.info("Subscription " + subscription.getSubscriptionId() + " is stale and will be deleted");
            }
            this.deleteSubscription(subscription);
            return;
        }
        String emailAddress = user.getEmailAddress();
        if (this._sentEmailAddresses.contains(emailAddress)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Do not send a duplicate email to " + emailAddress);
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Add " + emailAddress + " to the list of users who have received an email");
        }
        this._sentEmailAddresses.add(emailAddress);
        if (!user.isActive()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skip inactive user " + user.getUserId());
            }
            return;
        }
        try {
            if (!this.hasPermission(subscription, inferredClassName, inferredClassPK, user)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Skip unauthorized user " + user.getUserId());
                }
                return;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
            return;
        }
        if (this.bulk) {
            InternetAddress bulkAddress = new InternetAddress(user.getEmailAddress(), user.getFullName());
            if (this._bulkAddresses == null) {
                this._bulkAddresses = new ArrayList<InternetAddress>();
            }
            this._bulkAddresses.add(bulkAddress);
        } else {
            try {
                InternetAddress to = new InternetAddress(user.getEmailAddress(), user.getFullName());
                this.sendEmail(to, user.getLocale());
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    protected void processMailMessage(MailMessage mailMessage, Locale locale) throws Exception {
        InternetAddress from = mailMessage.getFrom();
        InternetAddress to = mailMessage.getTo()[0];
        String processedSubject = StringUtil.replace(mailMessage.getSubject(), new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, new String[]{from.getAddress(), GetterUtil.getString(from.getPersonal(), from.getAddress()), HtmlUtil.escape(to.getAddress()), HtmlUtil.escape(GetterUtil.getString(to.getPersonal(), to.getAddress()))});
        processedSubject = this.replaceContent(processedSubject, locale, false);
        mailMessage.setSubject(processedSubject);
        String processedBody = StringUtil.replace(mailMessage.getBody(), new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, new String[]{from.getAddress(), GetterUtil.getString(from.getPersonal(), from.getAddress()), HtmlUtil.escape(to.getAddress()), HtmlUtil.escape(GetterUtil.getString(to.getPersonal(), to.getAddress()))});
        processedBody = this.replaceContent(processedBody, locale, this.htmlFormat);
        mailMessage.setBody(processedBody);
    }

    protected String replaceContent(String content, Locale locale) throws Exception {
        return this.replaceContent(content, locale, true);
    }

    protected String replaceContent(String content, Locale locale, boolean escape) throws Exception {
        for (Map.Entry<String, EscapableObject<String>> entry : this._context.entrySet()) {
            String key = entry.getKey();
            EscapableObject<String> value = entry.getValue();
            String valueString = null;
            valueString = escape ? value.getEscapedValue() : value.getOriginalValue();
            content = StringUtil.replace(content, key, valueString);
        }
        if (Validator.isNotNull(this.portletId)) {
            String portletName = PortalUtil.getPortletTitle(this.portletId, locale);
            content = StringUtil.replace(content, "[$PORTLET_NAME$]", portletName);
        }
        Company company = CompanyLocalServiceUtil.getCompany(this.companyId);
        content = StringUtil.replace(content, new String[]{"href=\"/", "src=\"/"}, new String[]{"href=\"" + company.getPortalURL(this.groupId) + "/", "src=\"" + company.getPortalURL(this.groupId) + "/"});
        return content;
    }

    protected void sendEmail(InternetAddress to, Locale locale) throws Exception {
        InternetAddress from = new InternetAddress(this.replaceContent(this.fromAddress, locale), this.replaceContent(this.fromName, locale));
        String processedSubject = null;
        if (this.localizedSubjectMap != null) {
            String localizedSubject = this.localizedSubjectMap.get(locale);
            if (Validator.isNull(localizedSubject)) {
                Locale defaultLocale = LocaleUtil.getDefault();
                processedSubject = this.localizedSubjectMap.get(defaultLocale);
            } else {
                processedSubject = localizedSubject;
            }
        } else {
            processedSubject = this.subject;
        }
        String processedBody = null;
        if (this.localizedBodyMap != null) {
            String localizedBody = this.localizedBodyMap.get(locale);
            if (Validator.isNull(localizedBody)) {
                Locale defaultLocale = LocaleUtil.getDefault();
                processedBody = this.localizedBodyMap.get(defaultLocale);
            } else {
                processedBody = localizedBody;
            }
        } else {
            processedBody = this.body;
        }
        MailMessage mailMessage = new MailMessage(from, to, processedSubject, processedBody, this.htmlFormat);
        if (this.fileAttachments != null) {
            for (FileAttachment fileAttachment : this.fileAttachments) {
                mailMessage.addFileAttachment(fileAttachment.getFile(), fileAttachment.getFileName());
            }
        }
        if (this.bulk && this._bulkAddresses != null) {
            mailMessage.setBulkAddresses(this._bulkAddresses.toArray(new InternetAddress[this._bulkAddresses.size()]));
            this._bulkAddresses.clear();
        }
        if (this.inReplyTo != null) {
            mailMessage.setInReplyTo(this.inReplyTo);
        }
        mailMessage.setMessageId(this.mailId);
        if (this.replyToAddress != null) {
            InternetAddress replyTo = new InternetAddress(this.replaceContent(this.replyToAddress, locale), this.replaceContent(this.replyToAddress, locale));
            mailMessage.setReplyTo(new InternetAddress[]{replyTo});
        }
        if (this.smtpAccount != null) {
            mailMessage.setSMTPAccount(this.smtpAccount);
        }
        this.processMailMessage(mailMessage, locale);
        MailServiceUtil.sendEmail(mailMessage);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String servletContextName = objectInputStream.readUTF();
        if (!servletContextName.isEmpty()) {
            this._classLoader = ClassLoaderPool.getClassLoader(servletContextName);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        String servletContextName = "";
        if (this._classLoader != null) {
            servletContextName = ClassLoaderPool.getContextName(this._classLoader);
        }
        objectOutputStream.writeUTF(servletContextName);
    }
}

