/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public abstract class BaseAssetRenderer
implements AssetRenderer {
    private static final String[] _AVAILABLE_LANGUAGE_IDS = new String[0];
    private AssetRendererFactory _assetRendererFactory;
    private int _assetRendererType = 1;

    @Override
    public String getAddToPagePortletId() throws Exception {
        return "101";
    }

    public AssetRendererFactory getAssetRendererFactory() {
        if (this._assetRendererFactory != null) {
            return this._assetRendererFactory;
        }
        this._assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this.getClassName());
        return this._assetRendererFactory;
    }

    @Override
    public int getAssetRendererType() {
        return this._assetRendererType;
    }

    @Override
    public String[] getAvailableLanguageIds() {
        return _AVAILABLE_LANGUAGE_IDS;
    }

    @Override
    public String[] getAvailableLocales() {
        return this.getAvailableLanguageIds();
    }

    @Override
    public String getDiscussionPath() {
        return null;
    }

    @Override
    public Date getDisplayDate() {
        return null;
    }

    @Override
    public String getIconPath(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getIconPath(themeDisplay);
    }

    @Override
    public String getNewName(String oldName, String token) {
        return TrashUtil.getNewName(oldName, token);
    }

    @Override
    public String getPreviewPath(PortletRequest portletRequest, PortletResponse PortletResponse2) throws Exception {
        return "/html/portlet/asset_publisher/display/preview.jsp";
    }

    @Override
    public String getSearchSummary(Locale locale) {
        return this.getSummary(locale);
    }

    @Override
    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/large/default.png";
    }

    @Override
    public String getURLDownload(ThemeDisplay themeDisplay) {
        return null;
    }

    @Override
    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        return null;
    }

    @Override
    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, WindowState windowState, PortletURL redirectURL) throws Exception {
        LiferayPortletURL editPortletURL = (LiferayPortletURL)this.getURLEdit(liferayPortletRequest, liferayPortletResponse);
        if (editPortletURL == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getScopeGroup();
        if (group.isLayout()) {
            Layout layout = themeDisplay.getLayout();
            group = layout.getGroup();
        }
        if (group.hasStagingGroup()) {
            return null;
        }
        editPortletURL.setDoAsGroupId(this.getGroupId());
        editPortletURL.setParameter("redirect", redirectURL.toString());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String portletResource = ParamUtil.getString(liferayPortletRequest, "portletResource", portletDisplay.getId());
        if (Validator.isNotNull(portletResource)) {
            editPortletURL.setParameter("referringPortletResource", portletResource);
        } else {
            editPortletURL.setParameter("referringPortletResource", portletDisplay.getId());
        }
        editPortletURL.setPortletMode(PortletMode.VIEW);
        editPortletURL.setRefererPlid(themeDisplay.getPlid());
        editPortletURL.setWindowState(windowState);
        return editPortletURL;
    }

    @Override
    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        return null;
    }

    @Override
    public String getURLImagePreview(PortletRequest portletRequest) throws Exception {
        return this.getThumbnailPath(portletRequest);
    }

    @Override
    public String getUrlTitle() {
        return null;
    }

    @Override
    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        return null;
    }

    @Override
    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) throws Exception {
        return null;
    }

    @Override
    public String getViewInContextMessage() {
        return "view-in-context";
    }

    @Override
    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return false;
    }

    @Override
    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return true;
    }

    @Override
    public boolean isConvertible() {
        return false;
    }

    @Override
    public boolean isDisplayable() {
        return true;
    }

    @Override
    public boolean isLocalizable() {
        return false;
    }

    @Override
    public boolean isPreviewInContext() {
        return false;
    }

    @Override
    public boolean isPrintable() {
        return false;
    }

    public String renderActions(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return null;
    }

    @Override
    public void setAddToPagePreferences(PortletPreferences preferences, String portletId, ThemeDisplay themeDisplay) throws Exception {
        preferences.setValue("displayStyle", "full-content");
        preferences.setValue("emailAssetEntryAddedEnabled", Boolean.FALSE.toString());
        preferences.setValue("selectionStyle", "manual");
        preferences.setValue("showAddContentButton", Boolean.FALSE.toString());
        AssetEntry entry = AssetEntryLocalServiceUtil.getEntry(this.getClassName(), this.getClassPK());
        AssetPublisherUtil.addSelection(themeDisplay, preferences, portletId, entry.getEntryId(), -1, entry.getClassName());
    }

    public void setAssetRendererType(int assetRendererType) {
        this._assetRendererType = assetRendererType;
    }

    protected long getControlPanelPlid(LiferayPortletRequest liferayPortletRequest) throws PortalException, SystemException {
        return PortalUtil.getControlPanelPlid(liferayPortletRequest);
    }

    protected long getControlPanelPlid(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return PortalUtil.getControlPanelPlid(themeDisplay.getCompanyId());
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/page.png";
    }

    protected String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, String noSuchEntryRedirect, String path, String primaryKeyParameterName, long primaryKeyParameterValue) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        StringBundler sb = new StringBundler(11);
        sb.append(themeDisplay.getPortalURL());
        sb.append(themeDisplay.getPathMain());
        sb.append(path);
        sb.append("?p_l_id=");
        sb.append(themeDisplay.getPlid());
        sb.append("&noSuchEntryRedirect=");
        sb.append(HttpUtil.encodeURL(noSuchEntryRedirect));
        sb.append("&");
        sb.append(primaryKeyParameterName);
        sb.append("=");
        sb.append(primaryKeyParameterValue);
        return sb.toString();
    }
}

