/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;

public abstract class ThrowableAwareRunnable
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(ThrowableAwareRunnable.class);
    private Throwable _throwable;

    public Throwable getThrowable() {
        return this._throwable;
    }

    public boolean hasException() {
        return this._throwable != null;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        try {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info("Processing runnable " + ClassUtil.getClassName(this));
                }
                this.doRun();
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to process runnable", e);
                }
                this._throwable = e;
                if (_log.isInfoEnabled()) {
                    _log.info("Completed processing runnable " + ClassUtil.getClassName(this) + " in " + (System.currentTimeMillis() - start) + "ms");
                }
            }
        }
        finally {
            if (_log.isInfoEnabled()) {
                _log.info("Completed processing runnable " + ClassUtil.getClassName(this) + " in " + (System.currentTimeMillis() - start) + "ms");
            }
        }
    }

    protected abstract void doRun() throws Exception;
}

