/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.monitoring.statistics;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * @author Michael C. Han
 * @author Brian Wing Shun Chan
 */
public class DataSampleThreadLocal {

	public static void addDataSample(DataSample dataSample) {
		DataSampleThreadLocal dataSampleThreadLocal =
			_dataSampleThreadLocal.get();

		dataSampleThreadLocal._addDataSample(dataSample);
	}

	public static void clearDataSamples() {
		_dataSampleThreadLocal.remove();
	}

	public static List<DataSample> getDataSamples() {
		DataSampleThreadLocal dataSampleThreadLocal =
			_dataSampleThreadLocal.get();

		return ListUtil.fromCollection(dataSampleThreadLocal._getDataSamples());
	}

	public static void initialize() {
		_dataSampleThreadLocal.get();
	}

	@Override
	public Object clone() {
		return new DataSampleThreadLocal();
	}

	public long getMonitorTime() {
		return _monitorTime;
	}

	private DataSampleThreadLocal() {
		_monitorTime = System.currentTimeMillis();
	}

	private void _addDataSample(DataSample dataSample) {
		_dataSamples.add(dataSample);
	}

	private Queue<DataSample> _getDataSamples() {
		return _dataSamples;
	}

	private static ThreadLocal<DataSampleThreadLocal> _dataSampleThreadLocal =
		new AutoResetThreadLocal<DataSampleThreadLocal>(
			DataSampleThreadLocal.class + "._dataSampleThreadLocal") {

				@Override
				protected DataSampleThreadLocal copy(
					DataSampleThreadLocal dataSampleThreadLocal) {

					return dataSampleThreadLocal;
				}

				@Override
				protected DataSampleThreadLocal initialValue() {
					return new DataSampleThreadLocal();
				}

			};

	private Queue<DataSample> _dataSamples =
		new ConcurrentLinkedQueue<DataSample>();
	private long _monitorTime;

}