/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portletmvc4spring.test.mock.web.portlet;

import com.liferay.portletmvc4spring.test.mock.web.portlet.MockRenderURL;
import com.liferay.portletmvc4spring.test.mock.web.portlet.MockStateAwareResponse;
import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.RenderURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.springframework.util.Assert;

public class MockActionResponse
extends MockStateAwareResponse
implements ActionResponse {
    private boolean redirectAllowed = true;
    private String redirectedUrl;

    public MockActionResponse() {
    }

    public MockActionResponse(PortalContext portalContext) {
        super(portalContext);
    }

    public RenderURL createRedirectURL(MimeResponse.Copy copy) throws IllegalStateException {
        return new MockRenderURL(this.getPortalContext(), copy);
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public void sendRedirect(String location) throws IOException {
        if (!this.redirectAllowed) {
            throw new IllegalStateException("Cannot call sendRedirect after windowState, portletMode, or renderParameters have been set");
        }
        Assert.notNull((Object)location, (String)"Redirect URL must not be null");
        this.redirectedUrl = location;
    }

    public void sendRedirect(String location, String renderUrlParamName) throws IOException {
        this.sendRedirect(location);
        if (renderUrlParamName != null) {
            this.setRenderParameter(renderUrlParamName, location);
        }
    }

    @Override
    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set PortletMode after sendRedirect has been called");
        }
        super.setPortletMode(portletMode);
        this.redirectAllowed = false;
    }

    @Override
    public void setRenderParameter(String key, String value) {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set render parameters after sendRedirect has been called");
        }
        super.setRenderParameter(key, value);
        this.redirectAllowed = false;
    }

    @Override
    public void setRenderParameter(String key, String[] values) {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set render parameters after sendRedirect has been called");
        }
        super.setRenderParameter(key, values);
        this.redirectAllowed = false;
    }

    @Override
    public void setRenderParameters(Map<String, String[]> parameters) {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set render parameters after sendRedirect has been called");
        }
        super.setRenderParameters(parameters);
        this.redirectAllowed = false;
    }

    @Override
    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set WindowState after sendRedirect has been called");
        }
        super.setWindowState(windowState);
        this.redirectAllowed = false;
    }
}

