/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portletmvc4spring.test.mock.web.portlet;

import com.liferay.portletmvc4spring.test.mock.web.portlet.MockPortletRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.http.Part;

public class MockClientDataRequest
extends MockPortletRequest
implements ClientDataRequest {
    private String characterEncoding;
    private byte[] content;
    private String contentType;
    private String method;

    public MockClientDataRequest() {
    }

    public MockClientDataRequest(PortletContext portletContext) {
        super(portletContext);
    }

    public MockClientDataRequest(PortalContext portalContext, PortletContext portletContext) {
        super(portalContext, portletContext);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getMethod() {
        return this.method;
    }

    public Part getPart(String name) throws IOException, PortletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, PortletException {
        throw new UnsupportedOperationException();
    }

    public InputStream getPortletInputStream() throws IOException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        return null;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

