/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portletmvc4spring.test.mock.web.portlet;

import com.liferay.portletmvc4spring.test.mock.web.portlet.MockClientDataRequest;
import com.liferay.portletmvc4spring.test.mock.web.portlet.MockResourceParameters;
import com.liferay.portletmvc4spring.test.mock.web.portlet.MockResourceURL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletAsyncContext;
import javax.portlet.PortletContext;
import javax.portlet.ResourceParameters;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.DispatcherType;

public class MockResourceRequest
extends MockClientDataRequest
implements ResourceRequest {
    private String resourceID;
    private String cacheability;
    private final Map<String, String[]> privateRenderParameterMap = new LinkedHashMap<String, String[]>();
    private ResourceParameters resourceParameters;

    public MockResourceRequest() {
    }

    public MockResourceRequest(String resourceID) {
        this.resourceID = resourceID;
    }

    public MockResourceRequest(MockResourceURL url) {
        this.resourceID = url.getResourceID();
        this.cacheability = url.getCacheability();
    }

    public MockResourceRequest(PortletContext portletContext) {
        super(portletContext);
    }

    public MockResourceRequest(PortalContext portalContext, PortletContext portletContext) {
        super(portalContext, portletContext);
    }

    public void addPrivateRenderParameter(String key, String value) {
        this.privateRenderParameterMap.put(key, new String[]{value});
    }

    public void addPrivateRenderParameter(String key, String[] values) {
        this.privateRenderParameterMap.put(key, values);
    }

    public String getCacheability() {
        return this.cacheability;
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public String getETag() {
        return this.getProperty("portlet.ETag");
    }

    public PortletAsyncContext getPortletAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public Map<String, String[]> getPrivateRenderParameterMap() {
        return Collections.unmodifiableMap(this.privateRenderParameterMap);
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public ResourceParameters getResourceParameters() {
        if (this.resourceParameters == null) {
            this.resourceParameters = new MockResourceParameters();
        }
        return this.resourceParameters;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public void setCacheability(String cacheLevel) {
        this.cacheability = cacheLevel;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public PortletAsyncContext startPortletAsync() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public PortletAsyncContext startPortletAsync(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getLifecyclePhase() {
        return "RESOURCE_PHASE";
    }
}

