/*
 * Decompiled with CFR 0.152.
 */
package akka.coordination.lease.kubernetes;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.coordination.lease.LeaseException;
import akka.coordination.lease.LeaseSettings;
import akka.coordination.lease.LeaseTimeoutException;
import akka.coordination.lease.kubernetes.KubernetesLease$;
import akka.coordination.lease.kubernetes.KubernetesSettings;
import akka.coordination.lease.kubernetes.KubernetesSettings$;
import akka.coordination.lease.kubernetes.LeaseActor;
import akka.coordination.lease.kubernetes.LeaseActor$;
import akka.coordination.lease.kubernetes.LeaseActor$LeaseAcquired$;
import akka.coordination.lease.kubernetes.LeaseActor$LeaseReleased$;
import akka.coordination.lease.kubernetes.LeaseActor$LeaseTaken$;
import akka.coordination.lease.kubernetes.internal.KubernetesApiImpl;
import akka.coordination.lease.scaladsl.Lease;
import akka.dispatch.ExecutionContexts$;
import akka.pattern.AskTimeoutException;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.ConstantFun$;
import akka.util.Timeout;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]v!B\u0011#\u0011\u0003Yc!B\u0017#\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%\t\u0001\u000f\u0005\u0007\u0003\u0006\u0001\u000b\u0011B\u001d\t\u000f\t\u000b!\u0019!C\u0005\u0007\"1a*\u0001Q\u0001\n\u0011CQaT\u0001\u0005\nACQ!X\u0001\u0005\nyCQA\\\u0001\u0005\n=4A!\f\u0012\u0001c\"A\u0001P\u0003B\u0001B\u0003%\u0011\u0010C\u0005\u0000\u0015\t\u0005\t\u0015!\u0003\u0002\u0002!a\u0011q\u0001\u0006\u0003\u0002\u0003\u0006I!!\u0003\u0002\u0012!9QG\u0003C\u0001Q\u0005M\u0001\"CA\u000f\u0015\t\u0007I\u0011BA\u0010\u0011!\t\tD\u0003Q\u0001\n\u0005\u0005\u0002\"CA\u001a\u0015\t\u0007I\u0011BA\u001b\u0011!\tiD\u0003Q\u0001\n\u0005]\u0002\"CA \u0015\t\u0007I\u0011BA!\u0011!\tyE\u0003Q\u0001\n\u0005\r\u0003\"CA)\u0015\t\u0007I1BA*\u0011!\tyF\u0003Q\u0001\n\u0005U\u0003BB\u001b\u000b\t\u0003\t\t\u0007C\u0005\u0002j)\u0011\r\u0011\"\u0003\u0002l!9\u0011Q\u000e\u0006!\u0002\u0013\t\u0006\"CA8\u0015\t\u0007I\u0011BA9\u0011!\tIH\u0003Q\u0001\n\u0005M\u0004bBA>\u0015\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u000bSA\u0011IAD\u0011\u001d\t\u0019J\u0003C!\u0003\u000fCq!a%\u000b\t\u0003\n)\n\u0003\b\u00024*\u0001\n1!A\u0001\n\u0013\t),!\u0005\u0002\u001f-+(-\u001a:oKR,7\u000fT3bg\u0016T!a\t\u0013\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002&M\u0005)A.Z1tK*\u0011q\u0005K\u0001\rG>|'\u000fZ5oCRLwN\u001c\u0006\u0002S\u0005!\u0011m[6b\u0007\u0001\u0001\"\u0001L\u0001\u000e\u0003\t\u0012qbS;cKJtW\r^3t\u0019\u0016\f7/Z\n\u0003\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001,\u0003)\u0019wN\u001c4jOB\u000bG\u000f[\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$AB*ue&tw-A\u0006d_:4\u0017n\u001a)bi\"\u0004\u0013\u0001\u00047fCN,7i\\;oi\u0016\u0014X#\u0001#\u0011\u0005\u0015cU\"\u0001$\u000b\u0005\u001dC\u0015AB1u_6L7M\u0003\u0002J\u0015\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005-k\u0014\u0001B;uS2L!!\u0014$\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u00035aW-Y:f\u0007>,h\u000e^3sA\u00051BO];oG\u0006$X\rV87g\rC\u0017M]1di\u0016\u00148\u000f\u0006\u0002R7B\u0011!+\u0017\b\u0003'^\u0003\"\u0001V\u0019\u000e\u0003US!A\u0016\u0016\u0002\rq\u0012xn\u001c;?\u0013\tA\u0016'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001jS!\u0001W\u0019\t\u000bq;\u0001\u0019A)\u0002\t9\fW.Z\u0001\u0005iJLW\u000eF\u0002R?\u0002DQ\u0001\u0018\u0005A\u0002ECQ!\u0019\u0005A\u0002\t\f!b\u00195be\u0006\u001cG/\u001a:t!\r\u0019\u0007n\u001b\b\u0003I\u001at!\u0001V3\n\u0003IJ!aZ\u0019\u0002\u000fA\f7m[1hK&\u0011\u0011N\u001b\u0002\u0005\u0019&\u001cHO\u0003\u0002hcA\u0011\u0001\u0007\\\u0005\u0003[F\u0012Aa\u00115be\u0006)R.Y6f\t:\u001b\u0016\u0007M\u001a:\u0007>l\u0007/\u0019;jE2,GCA)q\u0011\u0015a\u0016\u00021\u0001R'\tQ!\u000f\u0005\u0002tm6\tAO\u0003\u0002vI\u0005A1oY1mC\u0012\u001cH.\u0003\u0002xi\n)A*Z1tK\u000611/_:uK6\u0004\"A_?\u000e\u0003mT!\u0001 \u0015\u0002\u000b\u0005\u001cGo\u001c:\n\u0005y\\(aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017A\u00037fCN,G+Y6f]B\u0019Q)a\u0001\n\u0007\u0005\u0015aIA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\tg\u0016$H/\u001b8hgB!\u00111BA\u0007\u001b\u0005!\u0013bAA\bI\tiA*Z1tKN+G\u000f^5oONL1!a\u0002w)!\t)\"a\u0006\u0002\u001a\u0005m\u0001C\u0001\u0017\u000b\u0011\u0015Ah\u00021\u0001z\u0011\u0019yh\u00021\u0001\u0002\u0002!9\u0011q\u0001\bA\u0002\u0005%\u0011A\u00027pO\u001e,'/\u0006\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!B:mMRR'BAA\u0016\u0003\ry'oZ\u0005\u0005\u0003_\t)C\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003-Y\u0007h]*fiRLgnZ:\u0016\u0005\u0005]\u0002c\u0001\u0017\u0002:%\u0019\u00111\b\u0012\u0003%-+(-\u001a:oKR,7oU3ui&twm]\u0001\rWb\u001a8+\u001a;uS:<7\u000fI\u0001\u0007Wb\u001a\u0018\t]5\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%#%\u0001\u0005j]R,'O\\1m\u0013\u0011\ti%a\u0012\u0003#-+(-\u001a:oKR,7/\u00119j\u00136\u0004H.A\u0004lqM\f\u0005/\u001b\u0011\u0002\u000fQLW.Z8viV\u0011\u0011Q\u000b\t\u0005\u0003/\nY&\u0004\u0002\u0002Z)\u00111\nK\u0005\u0005\u0003;\nIFA\u0004US6,w.\u001e;\u0002\u0011QLW.Z8vi\u0002\"b!!\u0006\u0002d\u0005\u001d\u0004bBA3/\u0001\u0007\u0011\u0011B\u0001\u000eY\u0016\f7/Z*fiRLgnZ:\t\u000ba<\u0002\u0019A=\u0002\u00131,\u0017m]3OC6,W#A)\u0002\u00151,\u0017m]3OC6,\u0007%\u0001\u0006mK\u0006\u001cX-Q2u_J,\"!a\u001d\u0011\u0007i\f)(C\u0002\u0002xm\u0014\u0001\"Q2u_J\u0014VMZ\u0001\fY\u0016\f7/Z!di>\u0014\b%\u0001\u0006dQ\u0016\u001c7\u000eT3bg\u0016$\"!a \u0011\u0007A\n\t)C\u0002\u0002\u0004F\u0012qAQ8pY\u0016\fg.A\u0004sK2,\u0017m]3\u0015\u0005\u0005%\u0005CBAF\u0003\u001f\u000by(\u0004\u0002\u0002\u000e*\u0011\u0011*M\u0005\u0005\u0003#\u000biI\u0001\u0004GkR,(/Z\u0001\bC\u000e\fX/\u001b:f)\u0011\tI)a&\t\u000f\u0005eu\u00041\u0001\u0002\u001c\u0006\tB.Z1tK2{7\u000f^\"bY2\u0014\u0017mY6\u0011\u000fA\ni*!)\u0002.&\u0019\u0011qT\u0019\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#\u0002\u0019\u0002$\u0006\u001d\u0016bAASc\t1q\n\u001d;j_:\u00042aYAU\u0013\r\tYK\u001b\u0002\n)\"\u0014xn^1cY\u0016\u00042\u0001MAX\u0013\r\t\t,\r\u0002\u0005+:LG/\u0001\btkB,'\u000fJ:fiRLgnZ:\u0016\u0005\u0005%\u0001")
public class KubernetesLease
extends Lease {
    private final ExtendedActorSystem system;
    private final AtomicBoolean leaseTaken;
    private final Logger logger;
    private final KubernetesSettings k8sSettings;
    private final KubernetesApiImpl k8sApi;
    private final Timeout timeout;
    private final String akka$coordination$lease$kubernetes$KubernetesLease$$leaseName;
    private final ActorRef leaseActor;

    public static String configPath() {
        return KubernetesLease$.MODULE$.configPath();
    }

    public /* synthetic */ LeaseSettings akka$coordination$lease$kubernetes$KubernetesLease$$super$settings() {
        return super.settings();
    }

    private Logger logger() {
        return this.logger;
    }

    private KubernetesSettings k8sSettings() {
        return this.k8sSettings;
    }

    private KubernetesApiImpl k8sApi() {
        return this.k8sApi;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public String akka$coordination$lease$kubernetes$KubernetesLease$$leaseName() {
        return this.akka$coordination$lease$kubernetes$KubernetesLease$$leaseName;
    }

    private ActorRef leaseActor() {
        return this.leaseActor;
    }

    public boolean checkLease() {
        return this.leaseTaken.get();
    }

    public Future<Object> release() {
        ActorRef qual$1 = package$.MODULE$.ask(this.leaseActor());
        LeaseActor.Release x$1 = new LeaseActor.Release();
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).flatMap((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (LeaseActor$LeaseReleased$.MODULE$.equals(object)) {
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            if (object instanceof LeaseActor.InvalidRequest) {
                LeaseActor.InvalidRequest invalidRequest = (LeaseActor.InvalidRequest)object;
                String msg = invalidRequest.reason();
                return Future$.MODULE$.failed((Throwable)new LeaseException(msg));
            }
            throw new MatchError(object);
        }, ExecutionContexts$.MODULE$.parasitic()).recoverWith((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ KubernetesLease $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AskTimeoutException) {
                    return (B1)Future$.MODULE$.failed((Throwable)new LeaseTimeoutException(new StringBuilder(62).append("Timed out trying to release lease [").append(this.$outer.akka$coordination$lease$kubernetes$KubernetesLease$$leaseName()).append(", ").append(this.$outer.akka$coordination$lease$kubernetes$KubernetesLease$$super$settings().ownerName()).append("]. It may still be taken.").toString()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof AskTimeoutException;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    public Future<Object> acquire() {
        return this.acquire((Function1<Option<Throwable>, BoxedUnit>)ConstantFun$.MODULE$.scalaAnyToUnit());
    }

    public Future<Object> acquire(Function1<Option<Throwable>, BoxedUnit> leaseLostCallback) {
        ActorRef qual$1 = package$.MODULE$.ask(this.leaseActor());
        LeaseActor.Acquire x$1 = new LeaseActor.Acquire(leaseLostCallback);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).flatMap((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (LeaseActor$LeaseAcquired$.MODULE$.equals(object)) {
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            if (LeaseActor$LeaseTaken$.MODULE$.equals(object)) {
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (object instanceof LeaseActor.InvalidRequest) {
                LeaseActor.InvalidRequest invalidRequest = (LeaseActor.InvalidRequest)object;
                String msg = invalidRequest.reason();
                return Future$.MODULE$.failed((Throwable)new LeaseException(msg));
            }
            throw new MatchError(object);
        }, (ExecutionContext)this.system.dispatcher()).recoverWith((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ KubernetesLease $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AskTimeoutException) {
                    return (B1)Future$.MODULE$.failed((Throwable)new LeaseTimeoutException(new StringBuilder(62).append("Timed out trying to acquire lease [").append(this.$outer.akka$coordination$lease$kubernetes$KubernetesLease$$leaseName()).append(", ").append(this.$outer.akka$coordination$lease$kubernetes$KubernetesLease$$super$settings().ownerName()).append("]. It may still be taken.").toString()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof AskTimeoutException;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    public KubernetesLease(ExtendedActorSystem system, AtomicBoolean leaseTaken, LeaseSettings settings) {
        this.system = system;
        this.leaseTaken = leaseTaken;
        super(settings);
        this.logger = LoggerFactory.getLogger(KubernetesLease.class);
        this.k8sSettings = KubernetesSettings$.MODULE$.apply(super.settings().leaseConfig(), super.settings().timeoutSettings());
        this.k8sApi = new KubernetesApiImpl((ActorSystem)system, this.k8sSettings());
        this.timeout = new Timeout(super.settings().timeoutSettings().operationTimeout());
        this.akka$coordination$lease$kubernetes$KubernetesLease$$leaseName = KubernetesLease$.MODULE$.akka$coordination$lease$kubernetes$KubernetesLease$$makeDNS1039Compatible(super.settings().leaseName());
        this.leaseActor = system.systemActorOf(LeaseActor$.MODULE$.props(this.k8sApi(), super.settings(), this.akka$coordination$lease$kubernetes$KubernetesLease$$leaseName(), leaseTaken), new StringBuilder(15).append("kubernetesLease").append(KubernetesLease$.MODULE$.akka$coordination$lease$kubernetes$KubernetesLease$$leaseCounter().incrementAndGet()).toString());
        String string = this.akka$coordination$lease$kubernetes$KubernetesLease$$leaseName();
        String string2 = super.settings().leaseName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.logger().info("Original lease name [{}] sanitized for kubernetes: [{}]", new Object[]{super.settings().leaseName(), this.akka$coordination$lease$kubernetes$KubernetesLease$$leaseName()});
        }
        this.logger().debug("Starting kubernetes lease actor [{}] for lease [{}], owner [{}]", new Object[]{this.leaseActor(), this.akka$coordination$lease$kubernetes$KubernetesLease$$leaseName(), super.settings().ownerName()});
    }

    public KubernetesLease(LeaseSettings leaseSettings, ExtendedActorSystem system) {
        this(system, new AtomicBoolean(false), leaseSettings);
    }
}

