/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.client.integration;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.CoordinatedShutdown;
import akka.japi.function.Effect;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import com.lightbend.lagom.internal.client.CircuitBreakerConfig;
import com.lightbend.lagom.internal.client.CircuitBreakerMetricsProviderImpl;
import com.lightbend.lagom.internal.client.WebSocketClient;
import com.lightbend.lagom.internal.client.WebSocketClientConfig;
import com.lightbend.lagom.internal.client.WebSocketClientConfig$;
import com.lightbend.lagom.internal.javadsl.api.broker.TopicFactory;
import com.lightbend.lagom.internal.javadsl.api.broker.TopicFactoryProvider;
import com.lightbend.lagom.internal.javadsl.client.CircuitBreakersPanelImpl;
import com.lightbend.lagom.internal.javadsl.client.JavadslServiceClientImplementor;
import com.lightbend.lagom.internal.javadsl.client.JavadslWebSocketClient;
import com.lightbend.lagom.internal.javadsl.client.ServiceClientLoader;
import com.lightbend.lagom.internal.javadsl.registry.JavaServiceRegistryClient;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistry;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistryServiceLocator;
import com.lightbend.lagom.internal.registry.ServiceRegistryClient;
import com.lightbend.lagom.internal.spi.CircuitBreakerMetricsProvider;
import com.lightbend.lagom.javadsl.api.Descriptor;
import com.lightbend.lagom.javadsl.api.ServiceAcl;
import com.lightbend.lagom.javadsl.api.ServiceInfo;
import com.lightbend.lagom.javadsl.api.ServiceLocator;
import com.lightbend.lagom.javadsl.broker.kafka.KafkaTopicFactory;
import com.lightbend.lagom.javadsl.client.CircuitBreakersPanel;
import com.lightbend.lagom.javadsl.client.CircuitBreakingServiceLocator;
import com.lightbend.lagom.javadsl.jackson.JacksonExceptionSerializer;
import com.lightbend.lagom.javadsl.jackson.JacksonSerializerFactory;
import com.typesafe.config.Config;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.pcollections.PVector;
import org.pcollections.TreePVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.internal.libs.concurrent.CoordinatedShutdownSupport;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.WSConfigParser;
import play.api.libs.ws.ahc.AhcWSClient;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfigParser;
import play.inject.ApplicationLifecycle;
import play.inject.DelegateApplicationLifecycle;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class LagomClientFactory
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(LagomClientFactory.class);
    private final EventLoopGroup eventLoop;
    private final WSClient wsClient;
    private final WebSocketClient webSocketClient;
    private final ActorSystem actorSystem;
    private final CircuitBreakersPanel circuitBreakersPanel;
    private final Function<ServiceLocator, ServiceClientLoader> serviceClientLoaderCreator;
    private final boolean managedActorSystem;

    private LagomClientFactory(EventLoopGroup eventLoopGroup, WSClient wSClient, WebSocketClient webSocketClient, ActorSystem actorSystem, CircuitBreakersPanel circuitBreakersPanel, Function<ServiceLocator, ServiceClientLoader> function, boolean bl) {
        this.eventLoop = eventLoopGroup;
        this.wsClient = wSClient;
        this.webSocketClient = webSocketClient;
        this.actorSystem = actorSystem;
        this.circuitBreakersPanel = circuitBreakersPanel;
        this.serviceClientLoaderCreator = function;
        this.managedActorSystem = bl;
    }

    public <T> T createClient(Class<T> clazz, ServiceLocator serviceLocator) {
        return (T)this.serviceClientLoaderCreator.apply(serviceLocator).loadServiceClient(clazz);
    }

    public <T> T createClient(Class<T> clazz, URI uRI) {
        return (T)this.serviceClientLoaderCreator.apply((ServiceLocator)new StaticServiceLocator(this.circuitBreakersPanel, uRI)).loadServiceClient(clazz);
    }

    public <T> T createClient(Class<T> clazz, Collection<URI> collection) {
        return (T)this.serviceClientLoaderCreator.apply((ServiceLocator)new RoundRobinServiceLocator(this.circuitBreakersPanel, (PVector<URI>)TreePVector.from(collection))).loadServiceClient(clazz);
    }

    public <T> T createDevClient(Class<T> clazz) {
        return this.createDevClient(clazz, URI.create("http://localhost:9008"));
    }

    public <T> T createDevClient(Class<T> clazz, URI uRI) {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.serviceClientLoaderCreator.apply((ServiceLocator)new StaticServiceLocator(this.circuitBreakersPanel, uRI)).loadServiceClient(ServiceRegistry.class);
        JavaServiceRegistryClient javaServiceRegistryClient = new JavaServiceRegistryClient(serviceRegistry, (ExecutionContext)this.actorSystem.dispatcher());
        ServiceRegistryServiceLocator serviceRegistryServiceLocator = new ServiceRegistryServiceLocator(this.circuitBreakersPanel, (ServiceRegistryClient)javaServiceRegistryClient, (ExecutionContext)this.actorSystem.dispatcher());
        return (T)this.serviceClientLoaderCreator.apply((ServiceLocator)serviceRegistryServiceLocator).loadServiceClient(clazz);
    }

    @Override
    public void close() {
        this.closeGracefully(() -> ((WSClient)this.wsClient).close());
        this.closeGracefully(() -> ((WebSocketClient)this.webSocketClient).shutdown());
        this.closeGracefully(this::coordinatedShutdown);
        this.closeGracefully((Effect & Serializable)() -> this.eventLoop.shutdownGracefully(0L, 10L, TimeUnit.SECONDS));
    }

    private void coordinatedShutdown() throws InterruptedException, TimeoutException {
        if (this.managedActorSystem) {
            CoordinatedShutdownSupport.syncShutdown((ActorSystem)this.actorSystem, (CoordinatedShutdown.Reason)new ClientStoppedReason());
        }
    }

    private static LagomClientFactory create(String string, Environment environment, Config config, ActorSystem actorSystem, Materializer materializer, boolean bl) {
        NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup();
        WSClientConfig wSClientConfig = new WSConfigParser(config, environment.classLoader()).parse();
        AhcWSClientConfig ahcWSClientConfig = new AhcWSClientConfigParser(wSClientConfig, config, environment.classLoader()).parse();
        AhcWSClient ahcWSClient = AhcWSClient.apply((AhcWSClientConfig)ahcWSClientConfig, (Option)Option.empty(), (Materializer)materializer);
        WebSocketClientConfig webSocketClientConfig = WebSocketClientConfig$.MODULE$.apply(config);
        play.api.inject.ApplicationLifecycle applicationLifecycle = new play.api.inject.ApplicationLifecycle(){

            public void addStopHook(Function0<Future<?>> function0) {
            }

            public void addStopHook(Callable<? extends CompletionStage<?>> callable) {
            }

            public ApplicationLifecycle asJava() {
                return new DelegateApplicationLifecycle((play.api.inject.ApplicationLifecycle)this);
            }

            public Future<?> stop() {
                return null;
            }
        };
        JavadslWebSocketClient javadslWebSocketClient = new JavadslWebSocketClient(environment, webSocketClientConfig, (EventLoopGroup)nioEventLoopGroup, applicationLifecycle, (ExecutionContext)actorSystem.dispatcher());
        ServiceInfo serviceInfo = ServiceInfo.of((String)string, (ServiceAcl[])new ServiceAcl[0]);
        CircuitBreakersPanelImpl circuitBreakersPanelImpl = new CircuitBreakersPanelImpl(actorSystem, new CircuitBreakerConfig(config), (CircuitBreakerMetricsProvider)new CircuitBreakerMetricsProviderImpl(actorSystem));
        JacksonSerializerFactory jacksonSerializerFactory = new JacksonSerializerFactory(actorSystem);
        JacksonExceptionSerializer jacksonExceptionSerializer = new JacksonExceptionSerializer(new play.Environment(environment));
        Function<ServiceLocator, ServiceClientLoader> function = arg_0 -> LagomClientFactory.lambda$create$1(serviceInfo, actorSystem, materializer, config, (WSClient)ahcWSClient, javadslWebSocketClient, environment, jacksonSerializerFactory, jacksonExceptionSerializer, arg_0);
        return new LagomClientFactory((EventLoopGroup)nioEventLoopGroup, (WSClient)ahcWSClient, (WebSocketClient)javadslWebSocketClient, actorSystem, (CircuitBreakersPanel)circuitBreakersPanelImpl, function, bl);
    }

    private static Environment buildtEnvironment(ClassLoader classLoader) {
        return Environment.apply((File)new File("."), (ClassLoader)classLoader, (Mode)Mode.Prod$.MODULE$);
    }

    private static Config buildConfig(ClassLoader classLoader) {
        return Configuration.load((ClassLoader)classLoader, (Properties)System.getProperties(), (Map)Map$.MODULE$.empty(), (boolean)true).underlying();
    }

    public static LagomClientFactory create(String string, ClassLoader classLoader, ActorSystem actorSystem, Materializer materializer) {
        return LagomClientFactory.create(string, LagomClientFactory.buildtEnvironment(classLoader), LagomClientFactory.buildConfig(classLoader), actorSystem, materializer, false);
    }

    public static LagomClientFactory create(String string, ClassLoader classLoader) {
        Environment environment = LagomClientFactory.buildtEnvironment(classLoader);
        Config config = LagomClientFactory.buildConfig(classLoader);
        ActorSystem actorSystem = ActorSystem.create((String)"lagom-client", (Config)config, (ClassLoader)classLoader);
        ActorMaterializer actorMaterializer = ActorMaterializer.create((ActorRefFactory)actorSystem);
        return LagomClientFactory.create(string, environment, config, actorSystem, (Materializer)actorMaterializer, true);
    }

    private void closeGracefully(Effect effect) {
        try {
            effect.apply();
        }
        catch (Exception exception) {
            this.log.warn("Error shutting down LagomClientFactory component", (Throwable)exception);
        }
    }

    private static /* synthetic */ ServiceClientLoader lambda$create$1(ServiceInfo serviceInfo, ActorSystem actorSystem, Materializer materializer, Config config, WSClient wSClient, JavadslWebSocketClient javadslWebSocketClient, Environment environment, JacksonSerializerFactory jacksonSerializerFactory, JacksonExceptionSerializer jacksonExceptionSerializer, ServiceLocator serviceLocator) {
        KafkaTopicFactory kafkaTopicFactory = new KafkaTopicFactory(serviceInfo, actorSystem, materializer, (ExecutionContext)actorSystem.dispatcher(), serviceLocator, config);
        TopicFactoryProvider topicFactoryProvider = () -> LagomClientFactory.lambda$null$0((TopicFactory)kafkaTopicFactory);
        JavadslServiceClientImplementor javadslServiceClientImplementor = new JavadslServiceClientImplementor(wSClient, javadslWebSocketClient, serviceInfo, serviceLocator, environment, topicFactoryProvider, (ExecutionContext)actorSystem.dispatcher(), materializer);
        return new ServiceClientLoader(jacksonSerializerFactory, jacksonExceptionSerializer, environment, javadslServiceClientImplementor);
    }

    private static /* synthetic */ Option lambda$null$0(TopicFactory topicFactory) {
        return Some.apply((Object)topicFactory);
    }

    private static class RoundRobinServiceLocator
    extends CircuitBreakingServiceLocator {
        private final PVector<URI> uris;
        private final AtomicInteger counter = new AtomicInteger(0);

        RoundRobinServiceLocator(CircuitBreakersPanel circuitBreakersPanel, PVector<URI> pVector) {
            super(circuitBreakersPanel);
            this.uris = pVector;
        }

        private URI nextUri() {
            int n = Math.abs(this.counter.getAndIncrement() % this.uris.size());
            return (URI)this.uris.get(n);
        }

        public CompletionStage<Optional<URI>> locate(String string, Descriptor.Call<?, ?> call) {
            return CompletableFuture.completedFuture(Optional.of(this.nextUri()));
        }
    }

    private static class StaticServiceLocator
    extends CircuitBreakingServiceLocator {
        private final URI uri;

        StaticServiceLocator(CircuitBreakersPanel circuitBreakersPanel, URI uRI) {
            super(circuitBreakersPanel);
            this.uri = uRI;
        }

        public CompletionStage<Optional<URI>> locate(String string, Descriptor.Call<?, ?> call) {
            return CompletableFuture.completedFuture(Optional.of(this.uri));
        }
    }

    static class ClientStoppedReason
    implements CoordinatedShutdown.Reason {
        ClientStoppedReason() {
        }
    }
}

