/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.jackson;

import akka.util.ByteString$;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.lightbend.lagom.javadsl.api.deser.ExceptionMessage;
import com.lightbend.lagom.javadsl.api.deser.ExceptionSerializer;
import com.lightbend.lagom.javadsl.api.deser.RawExceptionMessage;
import com.lightbend.lagom.javadsl.api.transport.MessageProtocol;
import com.lightbend.lagom.javadsl.api.transport.TransportErrorCode;
import com.lightbend.lagom.javadsl.api.transport.TransportException;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.Environment;

@Singleton
public class JacksonExceptionSerializer
implements ExceptionSerializer {
    private final ObjectMapper objectMapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).registerModule((Module)new Jdk8Module()).registerModule((Module)new ParameterNamesModule(JsonCreator.Mode.PROPERTIES));
    private final Environment environment;

    @Inject
    public JacksonExceptionSerializer(Environment environment) {
        this.environment = environment;
    }

    public RawExceptionMessage serialize(Throwable throwable, Collection<MessageProtocol> collection) {
        ExceptionMessage exceptionMessage;
        TransportErrorCode transportErrorCode;
        Object object;
        Throwable throwable2 = this.unwrap(throwable);
        if (throwable2 instanceof TransportException) {
            object = (TransportException)throwable2;
            transportErrorCode = object.errorCode();
            exceptionMessage = object.exceptionMessage();
        } else if (this.environment.isProd()) {
            transportErrorCode = TransportErrorCode.InternalServerError;
            exceptionMessage = new ExceptionMessage("Exception", "");
        } else {
            transportErrorCode = TransportErrorCode.InternalServerError;
            object = new CharArrayWriter();
            throwable2.printStackTrace(new PrintWriter((Writer)object));
            String string = ((CharArrayWriter)object).toString();
            exceptionMessage = new ExceptionMessage(throwable2.getClass().getName() + ": " + throwable2.getMessage(), string);
        }
        object = ByteString$.MODULE$.newBuilder();
        try {
            this.objectMapper.writeValue(object.asOutputStream(), (Object)exceptionMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RawExceptionMessage(transportErrorCode, new MessageProtocol(Optional.of("application/json"), Optional.of("utf-8"), Optional.empty()), object.result());
    }

    private Throwable unwrap(Throwable throwable) {
        if (throwable.getCause() != null && (throwable instanceof ExecutionException || throwable instanceof InvocationTargetException || throwable instanceof CompletionException)) {
            return this.unwrap(throwable.getCause());
        }
        return throwable;
    }

    public Throwable deserialize(RawExceptionMessage rawExceptionMessage) {
        ExceptionMessage exceptionMessage;
        try {
            exceptionMessage = (ExceptionMessage)this.objectMapper.readValue(rawExceptionMessage.message().iterator().asInputStream(), ExceptionMessage.class);
        }
        catch (Exception exception) {
            exceptionMessage = new ExceptionMessage("UndeserializableException", rawExceptionMessage.message().utf8String());
        }
        return TransportException.fromCodeAndMessage((TransportErrorCode)rawExceptionMessage.errorCode(), (ExceptionMessage)exceptionMessage);
    }
}

