/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.jackson;

import akka.Done;
import akka.actor.ActorSystem;
import akka.serialization.jackson.JacksonObjectMapperProvider;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.lightbend.lagom.javadsl.api.deser.DeserializationException;
import com.lightbend.lagom.javadsl.api.deser.MessageSerializer;
import com.lightbend.lagom.javadsl.api.deser.SerializationException;
import com.lightbend.lagom.javadsl.api.deser.SerializerFactory;
import com.lightbend.lagom.javadsl.api.deser.StrictMessageSerializer;
import com.lightbend.lagom.javadsl.api.transport.MessageProtocol;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.pcollections.PSequence;
import org.pcollections.TreePVector;
import scala.Option;

@Singleton
public class JacksonSerializerFactory
implements SerializerFactory {
    public static String BINDING_NAME = "jackson-json-serviceapi";
    private final MessageProtocol defaultProtocol = new MessageProtocol(Optional.of("application/json"), Optional.of("utf-8"), Optional.empty());
    private final ObjectMapper objectMapper;

    @Inject
    public JacksonSerializerFactory(ActorSystem actorSystem) {
        this(JacksonObjectMapperProvider.get((ActorSystem)actorSystem).getOrCreate(BINDING_NAME, Option.empty()));
    }

    public JacksonSerializerFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <MessageEntity> StrictMessageSerializer<MessageEntity> messageSerializerFor(Type type) {
        if (type == Done.class) {
            return new DoneMessageSerializer();
        }
        if (type == ByteString.class) {
            return new NoopMessageSerializer();
        }
        return new JacksonMessageSerializer(type);
    }

    private class NoopMessageSerializer<MessageEntity>
    implements StrictMessageSerializer<MessageEntity> {
        private final MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializer = new NoopSerializer();
        private final MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> deserializer = new NoopDeserializer();

        private NoopMessageSerializer() {
        }

        public MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializerForRequest() {
            return this.serializer;
        }

        public MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> deserializer(MessageProtocol messageProtocol) throws SerializationException {
            return this.deserializer;
        }

        public MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializerForResponse(List<MessageProtocol> list) {
            return this.serializer;
        }

        private class NoopDeserializer
        implements MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> {
            private NoopDeserializer() {
            }

            public MessageEntity deserialize(ByteString byteString) {
                return byteString;
            }
        }

        private class NoopSerializer
        implements MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> {
            private NoopSerializer() {
            }

            public MessageProtocol protocol() {
                return JacksonSerializerFactory.this.defaultProtocol;
            }

            public ByteString serialize(MessageEntity MessageEntity) {
                return (ByteString)MessageEntity;
            }
        }
    }

    private class DoneMessageSerializer<MessageEntity>
    implements StrictMessageSerializer<MessageEntity> {
        private final MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializer = new DoneSerializer();
        private final MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> deserializer = new DoneDeserializer();

        private DoneMessageSerializer() {
        }

        public PSequence<MessageProtocol> acceptResponseProtocols() {
            return TreePVector.singleton((Object)new MessageProtocol(Optional.of("application/json"), Optional.empty(), Optional.empty()));
        }

        public MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializerForRequest() {
            return this.serializer;
        }

        public MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> deserializer(MessageProtocol messageProtocol) throws SerializationException {
            return this.deserializer;
        }

        public MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializerForResponse(List<MessageProtocol> list) {
            return this.serializer;
        }

        private class DoneDeserializer
        implements MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> {
            private DoneDeserializer() {
            }

            public MessageEntity deserialize(ByteString byteString) {
                return Done.getInstance();
            }
        }

        private class DoneSerializer
        implements MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> {
            private final ByteString doneJson = ByteString.fromString((String)"{ \"done\" : true }");

            private DoneSerializer() {
            }

            public MessageProtocol protocol() {
                return JacksonSerializerFactory.this.defaultProtocol;
            }

            public ByteString serialize(MessageEntity MessageEntity) {
                return this.doneJson;
            }
        }
    }

    private class JacksonMessageSerializer<MessageEntity>
    implements StrictMessageSerializer<MessageEntity> {
        private final MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializer;
        private final MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> deserializer;

        public JacksonMessageSerializer(Type type) {
            JavaType javaType = JacksonSerializerFactory.this.objectMapper.constructType(type);
            this.serializer = new JacksonSerializer(JacksonSerializerFactory.this.objectMapper.writerFor(javaType));
            this.deserializer = new JacksonDeserializer(JacksonSerializerFactory.this.objectMapper.readerFor(javaType), type);
        }

        public PSequence<MessageProtocol> acceptResponseProtocols() {
            return TreePVector.singleton((Object)new MessageProtocol(Optional.of("application/json"), Optional.empty(), Optional.empty()));
        }

        public MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializerForRequest() {
            return this.serializer;
        }

        public MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> deserializer(MessageProtocol messageProtocol) throws SerializationException {
            return this.deserializer;
        }

        public MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> serializerForResponse(List<MessageProtocol> list) {
            return this.serializer;
        }

        private class JacksonDeserializer
        implements MessageSerializer.NegotiatedDeserializer<MessageEntity, ByteString> {
            private final ObjectReader reader;
            private final Type type;

            public JacksonDeserializer(ObjectReader objectReader, Type type) {
                this.reader = objectReader;
                this.type = type;
            }

            public MessageEntity deserialize(ByteString byteString) {
                try {
                    if (byteString.isEmpty() && this.type == Optional.class) {
                        byteString = ByteString.fromString((String)"null");
                    }
                    return this.reader.readValue(byteString.iterator().asInputStream());
                }
                catch (Exception exception) {
                    throw new DeserializationException((Throwable)exception);
                }
            }
        }

        private class JacksonSerializer
        implements MessageSerializer.NegotiatedSerializer<MessageEntity, ByteString> {
            private final ObjectWriter writer;

            public JacksonSerializer(ObjectWriter objectWriter) {
                this.writer = objectWriter;
            }

            public MessageProtocol protocol() {
                return JacksonSerializerFactory.this.defaultProtocol;
            }

            public ByteString serialize(MessageEntity MessageEntity) {
                ByteStringBuilder byteStringBuilder = ByteString$.MODULE$.newBuilder();
                try {
                    this.writer.writeValue(byteStringBuilder.asOutputStream(), MessageEntity);
                }
                catch (Exception exception) {
                    throw new SerializationException((Throwable)exception);
                }
                return byteStringBuilder.result();
            }
        }
    }
}

