/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.persistence;

import java.util.UUID;

public abstract class Offset {
    public static final Offset NONE = new NoOffset();

    private Offset() {
    }

    public static Offset sequence(long l) {
        return new Sequence(l);
    }

    public static Offset timeBasedUUID(UUID uUID) {
        return new TimeBasedUUID(uUID);
    }

    public static final class NoOffset
    extends Offset {
        private NoOffset() {
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object instanceof NoOffset;
        }

        public String toString() {
            return "NoOffset";
        }
    }

    public static final class TimeBasedUUID
    extends Offset
    implements Comparable<TimeBasedUUID> {
        private final UUID value;

        public TimeBasedUUID(UUID uUID) {
            if (uUID == null || uUID.version() != 1) {
                throw new IllegalArgumentException("UUID " + uUID + " is not a time-based UUID");
            }
            this.value = uUID;
        }

        public UUID value() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TimeBasedUUID timeBasedUUID = (TimeBasedUUID)object;
            return this.value.equals(timeBasedUUID.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public int compareTo(TimeBasedUUID timeBasedUUID) {
            return this.value.compareTo(timeBasedUUID.value);
        }
    }

    public static final class Sequence
    extends Offset
    implements Comparable<Sequence> {
        private final long value;

        public Sequence(long l) {
            this.value = l;
        }

        public long value() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Sequence sequence = (Sequence)object;
            return this.value == sequence.value;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public String toString() {
            return Long.toString(this.value);
        }

        @Override
        public int compareTo(Sequence sequence) {
            return Long.compare(this.value, sequence.value);
        }
    }
}

