/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.persistence;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.NoSerializationVerificationNeeded;
import akka.pattern.Patterns;
import com.lightbend.lagom.javadsl.persistence.CommandEnvelope;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import scala.concurrent.duration.FiniteDuration;

public final class PersistentEntityRef<Command>
implements NoSerializationVerificationNeeded {
    private final String entityId;
    private final ActorRef region;
    private final Duration timeout;

    @Deprecated
    public PersistentEntityRef(String string, ActorRef actorRef, FiniteDuration finiteDuration) {
        this.entityId = string;
        this.region = actorRef;
        this.timeout = Duration.ofMillis(finiteDuration.toMillis());
    }

    public PersistentEntityRef(String string, ActorRef actorRef, Duration duration) {
        this.entityId = string;
        this.region = actorRef;
        this.timeout = duration;
    }

    @Deprecated
    public PersistentEntityRef(String string, ActorRef actorRef, ActorSystem actorSystem, FiniteDuration finiteDuration) {
        this(string, actorRef, finiteDuration);
    }

    public String entityId() {
        return this.entityId;
    }

    public <Reply, Cmd> CompletionStage<Reply> ask(Cmd Cmd) {
        CompletionStage completionStage = Patterns.ask((ActorRef)this.region, (Object)new CommandEnvelope(this.entityId, Cmd), (Duration)this.timeout);
        return completionStage.thenCompose(object -> {
            if (object instanceof Throwable) {
                CompletableFuture completableFuture = new CompletableFuture();
                completableFuture.completeExceptionally((Throwable)object);
                return completableFuture;
            }
            return CompletableFuture.completedFuture(object);
        });
    }

    @Deprecated
    public PersistentEntityRef<Command> withAskTimeout(FiniteDuration finiteDuration) {
        return new PersistentEntityRef<Command>(this.entityId, this.region, finiteDuration);
    }

    public PersistentEntityRef<Command> withAskTimeout(Duration duration) {
        return new PersistentEntityRef<Command>(this.entityId, this.region, duration);
    }

    private Object writeReplace() throws ObjectStreamException {
        throw new NotSerializableException(this.getClass().getName() + " is not serializable. Send the entityId instead.");
    }

    public String toString() {
        return "PersistentEntityRef(" + this.entityId + ")";
    }
}

