/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.server;

import akka.annotation.ApiMayChange;
import akka.annotation.InternalApi;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.lightbend.lagom.internal.javadsl.BinderAccessor;
import com.lightbend.lagom.internal.javadsl.server.AdditionalRoutersProvider;
import com.lightbend.lagom.internal.javadsl.server.JavadslServicesRouter;
import com.lightbend.lagom.internal.javadsl.server.ResolvedServices;
import com.lightbend.lagom.internal.javadsl.server.ResolvedServicesProvider;
import com.lightbend.lagom.internal.javadsl.server.ServiceInfoProvider;
import com.lightbend.lagom.internal.server.status.MetricsServiceImpl;
import com.lightbend.lagom.javadsl.api.Service;
import com.lightbend.lagom.javadsl.api.ServiceInfo;
import com.lightbend.lagom.javadsl.client.ServiceClientGuiceSupport;
import com.lightbend.lagom.javadsl.server.AdditionalRouter;
import com.lightbend.lagom.javadsl.server.ClassBased;
import com.lightbend.lagom.javadsl.server.InstanceBased;
import com.lightbend.lagom.javadsl.server.LagomServiceRouter;
import com.lightbend.lagom.javadsl.server.status.MetricsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;
import play.api.routing.Router;

public interface ServiceGuiceSupport
extends ServiceClientGuiceSupport {
    @ApiMayChange
    default public <R extends Router> AdditionalRouter additionalRouter(Class<R> clazz) {
        return new ClassBased<R>(clazz);
    }

    @ApiMayChange
    default public AdditionalRouter additionalRouter(Router router) {
        return new InstanceBased(router);
    }

    default public void bindServiceInfo(ServiceInfo serviceInfo) {
        Binder binder = BinderAccessor.binder((Object)this);
        binder.bind(ServiceInfo.class).toInstance((Object)serviceInfo);
        ServiceBinding<Class<MetricsServiceImpl>> serviceBinding = this.serviceBinding((Class)MetricsService.class, (Object)MetricsServiceImpl.class);
        binder.bind(((ClassServiceBinding)serviceBinding).serviceImplementation).asEagerSingleton();
        ServiceBinding[] serviceBindingArray = new ServiceBinding[]{serviceBinding};
        binder.bind(ResolvedServices.class).toProvider((Provider)new ResolvedServicesProvider(serviceBindingArray));
        binder.bind((TypeLiteral)new TypeLiteral<List<Router>>(){}).toInstance(Collections.emptyList());
        binder.bind(LagomServiceRouter.class).to(JavadslServicesRouter.class);
    }

    default public void bindServices(ServiceBinding<?> ... serviceBindingArray) {
        Binder binder = BinderAccessor.binder((Object)this);
        for (ServiceBinding<?> serviceBinding : serviceBindingArray) {
            this.bindClient(serviceBinding.serviceInterface());
            if (serviceBinding instanceof ClassServiceBinding) {
                binder.bind(((ClassServiceBinding)serviceBinding).serviceImplementation).asEagerSingleton();
                continue;
            }
            Object object = ((InstanceServiceBinding)serviceBinding).service;
            binder.bind(object.getClass()).toInstance(object);
        }
        ServiceBinding<?> serviceBinding = serviceBindingArray[0];
        binder.bind(ServiceInfo.class).toProvider((Provider)new ServiceInfoProvider(serviceBinding.serviceInterface(), (Class[])Arrays.stream(serviceBindingArray).map(ServiceBinding::serviceInterface).toArray(Class[]::new)));
        ServiceBinding<Class<MetricsServiceImpl>> serviceBinding2 = this.serviceBinding((Class)MetricsService.class, (Object)MetricsServiceImpl.class);
        binder.bind(((ClassServiceBinding)serviceBinding2).serviceImplementation).asEagerSingleton();
        ServiceBinding[] serviceBindingArray2 = new ServiceBinding[serviceBindingArray.length + 1];
        System.arraycopy(serviceBindingArray, 0, serviceBindingArray2, 0, serviceBindingArray.length);
        serviceBindingArray2[serviceBindingArray2.length - 1] = serviceBinding2;
        binder.bind(ResolvedServices.class).toProvider((Provider)new ResolvedServicesProvider(serviceBindingArray2));
        binder.bind((TypeLiteral)new TypeLiteral<List<Router>>(){}).toInstance(Collections.emptyList());
        binder.bind(LagomServiceRouter.class).to(JavadslServicesRouter.class);
    }

    default public <T extends Service> void bindService(Class<T> clazz, Class<? extends T> clazz2) {
        new LagomServiceBuilder(this.serviceBinding(clazz, (T)clazz2), this).bind();
    }

    default public <T extends Service> void bindService(Class<T> clazz, Class<? extends T> clazz2, AdditionalRouter additionalRouter, AdditionalRouter ... additionalRouterArray) {
        new LagomServiceBuilder(this.serviceBinding(clazz, (T)clazz2), this).withAdditionalRouters(additionalRouter, additionalRouterArray).bind();
    }

    default public <T extends Service> void bindService(Class<T> clazz, T t) {
        new LagomServiceBuilder(this.serviceBinding(clazz, t), this).bind();
    }

    default public <T extends Service> void bindService(Class<T> clazz, T t, AdditionalRouter additionalRouter, AdditionalRouter ... additionalRouterArray) {
        new LagomServiceBuilder(this.serviceBinding(clazz, t), this).withAdditionalRouters(additionalRouter, additionalRouterArray).bind();
    }

    default public <T> ServiceBinding<T> serviceBinding(Class<T> clazz, Class<? extends T> clazz2) {
        return new ClassServiceBinding(clazz, clazz2);
    }

    default public <T> ServiceBinding<T> serviceBinding(Class<T> clazz, T t) {
        return new InstanceServiceBinding<T>(clazz, t);
    }

    public static final class InstanceServiceBinding<T>
    extends ServiceBinding<T> {
        private final Class<T> serviceInterface;
        private final T service;

        public InstanceServiceBinding(Class<T> clazz, T t) {
            this.serviceInterface = clazz;
            this.service = t;
        }

        @Override
        public Class<T> serviceInterface() {
            return this.serviceInterface;
        }

        public T service() {
            return this.service;
        }
    }

    public static final class ClassServiceBinding<T>
    extends ServiceBinding<T> {
        private final Class<T> serviceInterface;
        private final Class<? extends T> serviceImplementation;

        private ClassServiceBinding(Class<T> clazz, Class<? extends T> clazz2) {
            this.serviceInterface = clazz;
            this.serviceImplementation = clazz2;
        }

        @Override
        public Class<T> serviceInterface() {
            return this.serviceInterface;
        }

        public Class<? extends T> serviceImplementation() {
            return this.serviceImplementation;
        }
    }

    public static abstract class ServiceBinding<T> {
        private ServiceBinding() {
        }

        public abstract Class<T> serviceInterface();
    }

    @InternalApi
    public static class LagomServiceBuilder {
        private ServiceBinding<?> binding;
        private ServiceGuiceSupport guiceSupport;
        private List<AdditionalRouter> additionalRouters = new ArrayList<AdditionalRouter>();

        private LagomServiceBuilder(ServiceBinding<?> serviceBinding, ServiceGuiceSupport serviceGuiceSupport) {
            this.binding = serviceBinding;
            this.guiceSupport = serviceGuiceSupport;
        }

        private LagomServiceBuilder withAdditionalRouters(AdditionalRouter additionalRouter, AdditionalRouter ... additionalRouterArray) {
            this.additionalRouters.add(additionalRouter);
            this.additionalRouters.addAll(Arrays.asList(additionalRouterArray));
            return this;
        }

        public void bind() {
            ServiceBinding<Class<MetricsServiceImpl>> serviceBinding;
            Binder binder = BinderAccessor.binder((Object)this.guiceSupport);
            this.guiceSupport.bindClient(this.binding.serviceInterface());
            if (this.binding instanceof ClassServiceBinding) {
                binder.bind(((ClassServiceBinding)this.binding).serviceImplementation).asEagerSingleton();
            } else {
                serviceBinding = ((InstanceServiceBinding)this.binding).service;
                binder.bind(serviceBinding.getClass()).toInstance((Object)serviceBinding);
            }
            binder.bind(ServiceInfo.class).toProvider((Provider)new ServiceInfoProvider(this.binding.serviceInterface(), new Class[0]));
            serviceBinding = this.guiceSupport.serviceBinding(MetricsService.class, MetricsServiceImpl.class);
            binder.bind(((ClassServiceBinding)serviceBinding).serviceImplementation).asEagerSingleton();
            binder.bind(ResolvedServices.class).toProvider((Provider)new ResolvedServicesProvider(new ServiceBinding[]{this.binding, serviceBinding}));
            binder.bind((TypeLiteral)new TypeLiteral<List<AdditionalRouter>>(){}).toInstance(this.additionalRouters);
            binder.bind((TypeLiteral)new TypeLiteral<List<Router>>(){}).toProvider(AdditionalRoutersProvider.class);
            binder.bind(LagomServiceRouter.class).to(JavadslServicesRouter.class);
        }
    }
}

