/*
 * Decompiled with CFR 0.152.
 */
package mill.scalalib.publish;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import mill.api.Logger;
import mill.modules.Jvm$;
import mill.scalalib.publish.Artifact;
import mill.scalalib.publish.SonatypeHttpApi;
import mill.scalalib.publish.SonatypePublisher$;
import os.Path;
import os.Path$;
import os.PathConvertible;
import os.ReadablePath;
import os.read;
import requests.Response;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u0012%\u0001-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%1\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011I\u0003!\u0011!Q\u0001\n=C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t5\u0002\u0011\t\u0011)A\u00057\"A\u0011\r\u0001B\u0001B\u0003%!\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003P\u0011!1\u0007A!A!\u0002\u0013\t\u0005\"B4\u0001\t\u0003A\u0007\"B4\u0001\t\u00039\b\u0002C,\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037Aa!\n\u0001\u0005\u0002\u0005\r\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003/\u0002A\u0011BA-\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!! \u0001\t\u0013\ty\bC\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBA^\u0001\u0011%\u0011Q\u0018\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\ty\r\u0001C\u0005\u0003#Dq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002j\u0002!I!a6\t\u000f\u0005-\b\u0001\"\u0003\u0002n\u001eI\u0011Q \u0013\u0002\u0002#\u0005\u0011q \u0004\tG\u0011\n\t\u0011#\u0001\u0003\u0002!1q\r\tC\u0001\u0005\u0007A\u0011B!\u0002!#\u0003%\tAa\u0002\u0003#M{g.\u0019;za\u0016\u0004VO\u00197jg\",'O\u0003\u0002&M\u00059\u0001/\u001e2mSND'BA\u0014)\u0003!\u00198-\u00197bY&\u0014'\"A\u0015\u0002\t5LG\u000e\\\u0002\u0001'\t\u0001A\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VMZ\u0001\u0004kJL\u0007C\u0001\u001b<\u001d\t)\u0014\b\u0005\u00027]5\tqG\u0003\u00029U\u00051AH]8pizJ!A\u000f\u0018\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u9\n1b\u001d8baNDw\u000e^+sS\u0006Y1M]3eK:$\u0018.\u00197t\u0003\u0019\u0019\u0018n\u001a8fIB\u0011QFQ\u0005\u0003\u0007:\u0012qAQ8pY\u0016\fg.A\u0004ha\u001e\f%oZ:\u0011\u0007\u0019[5G\u0004\u0002H\u0013:\u0011a\u0007S\u0005\u0002_%\u0011!JL\u0001\ba\u0006\u001c7.Y4f\u0013\taUJA\u0002TKFT!A\u0013\u0018\u0002\u0017I,\u0017\r\u001a+j[\u0016|W\u000f\u001e\t\u0003[AK!!\u0015\u0018\u0003\u0007%sG/\u0001\bd_:tWm\u0019;US6,w.\u001e;\u0002\u00071|w\r\u0005\u0002V16\taK\u0003\u0002XQ\u0005\u0019\u0011\r]5\n\u0005e3&A\u0002'pO\u001e,'/A\u0005x_J\\7\u000f]1dKB\u0011AlX\u0007\u0002;*\ta,\u0001\u0002pg&\u0011\u0001-\u0018\u0002\u0005!\u0006$\b.A\u0002f]Z\u0004B\u0001N24g%\u0011A-\u0010\u0002\u0004\u001b\u0006\u0004\u0018\u0001D1xC&$H+[7f_V$\u0018AD:uC\u001eLgn\u001a*fY\u0016\f7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001b%\\G.\u001c8paF\u00148\u000f^;w!\tQ\u0007!D\u0001%\u0011\u0015\u0011T\u00021\u00014\u0011\u0015qT\u00021\u00014\u0011\u0015yT\u00021\u00014\u0011\u0015\u0001U\u00021\u0001B\u0011\u0015!U\u00021\u0001F\u0011\u0015qU\u00021\u0001P\u0011\u0015\u0011V\u00021\u0001P\u0011\u0015\u0019V\u00021\u0001U\u0011\u0015QV\u00021\u0001\\\u0011\u0015\tW\u00021\u0001c\u0011\u0015)W\u00021\u0001P\u0011\u00151W\u00021\u0001B)5I\u00070\u001f>|yvtx0!\u0001\u0002\u0004!)!G\u0004a\u0001g!)aH\u0004a\u0001g!)qH\u0004a\u0001g!)\u0001I\u0004a\u0001\u0003\")AI\u0004a\u0001\u000b\")aJ\u0004a\u0001\u001f\")!K\u0004a\u0001\u001f\")1K\u0004a\u0001)\")QM\u0004a\u0001\u001f\"9aM\u0004I\u0001\u0002\u0004\t\u0005f\u0003\b\u0002\b\u00055\u0011qBA\n\u0003+\u00012!LA\u0005\u0013\r\tYA\f\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017aB7fgN\fw-Z\u0011\u0003\u0003#\tQ$V:fA=$\b.\u001a:!G>t7\u000f\u001e:vGR|'\u000fI5ogR,\u0017\rZ\u0001\u0006g&t7-Z\u0011\u0003\u0003/\t1\"\\5mY\u0002\u0002d&\r\u0019/qU\u0011\u00111\u0004\t\u0004U\u0006u\u0011bAA\u0010I\ty1k\u001c8bif\u0004X\r\u0013;ua\u0006\u0003\u0018.\u0001\u0003ba&\u0004C\u0003CA\u0013\u0003W\t9$!\u0011\u0011\u00075\n9#C\u0002\u0002*9\u0012A!\u00168ji\"9\u0011QF\tA\u0002\u0005=\u0012a\u00034jY\u0016l\u0015\r\u001d9j]\u001e\u0004BAR&\u00022A)Q&a\r\\g%\u0019\u0011Q\u0007\u0018\u0003\rQ+\b\u000f\\33\u0011\u001d\tI$\u0005a\u0001\u0003w\t\u0001\"\u0019:uS\u001a\f7\r\u001e\t\u0004U\u0006u\u0012bAA I\tA\u0011I\u001d;jM\u0006\u001cG\u000f\u0003\u0004\u0002DE\u0001\r!Q\u0001\be\u0016dW-Y:f\u0003)\u0001XO\u00197jg\"\fE\u000e\u001c\u000b\u0007\u0003K\tI%a\u0013\t\r\u0005\r#\u00031\u0001B\u0011\u001d\tiE\u0005a\u0001\u0003\u001f\n\u0011\"\u0019:uS\u001a\f7\r^:\u0011\u000b5\n\t&!\u0016\n\u0007\u0005McF\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002r!LA\u001a\u0003_\tY$A\bqk\nd\u0017n\u001d5T]\u0006\u00048\u000f[8u)\u0019\t)#a\u0017\u0002p!9\u0011QL\nA\u0002\u0005}\u0013\u0001\u00039bs2|\u0017\rZ:\u0011\t\u0019[\u0015\u0011\r\t\u0007[\u0005M2'a\u0019\u0011\u000b5\n)'!\u001b\n\u0007\u0005\u001ddFA\u0003BeJ\f\u0017\u0010E\u0002.\u0003WJ1!!\u001c/\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u000553\u00031\u0001\u0002rA!aiSA\u001e\u00031\u0001XO\u00197jg\"$v.\u0016:j)!\t)#a\u001e\u0002z\u0005m\u0004bBA/)\u0001\u0007\u0011q\f\u0005\b\u0003\u001b\"\u0002\u0019AA9\u0011\u0015\u0011D\u00031\u00014\u0003a\u0001XO\u00197jg\"\u0014V\r\\3bg\u0016tuN\\:uC\u001eLgn\u001a\u000b\u0007\u0003K\t\t)a!\t\u000f\u0005uS\u00031\u0001\u0002`!9\u0011QJ\u000bA\u0002\u0005E\u0014A\u00049vE2L7\u000f\u001b*fY\u0016\f7/\u001a\u000b\r\u0003K\tI)a#\u0002\u000e\u0006E\u00151\u0013\u0005\u0007\u0003\u00072\u0002\u0019A!\t\u000f\u0005uc\u00031\u0001\u0002`!1\u0011q\u0012\fA\u0002M\nab\u001d;bO&tw\r\u0015:pM&dW\rC\u0004\u0002NY\u0001\r!!\u001d\t\u000b\u00154\u0002\u0019A(\u0002)I,\u0007o\u001c:u!V\u0014G.[:i%\u0016\u001cX\u000f\u001c;t)\u0019\t)#!'\u0002,\"9\u00111T\fA\u0002\u0005u\u0015A\u00049vE2L7\u000f\u001b*fgVdGo\u001d\t\u0005\r.\u000by\n\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\t\t)+\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tI+a)\u0003\u0011I+7\u000f]8og\u0016Dq!!\u0014\u0018\u0001\u0004\t\t(A\bbo\u0006LGOU3q_N#\u0018\r^;t)!\t)#!-\u00026\u0006e\u0006BBAZ1\u0001\u00071'\u0001\u0004ti\u0006$Xo\u001d\u0005\u0007\u0003oC\u0002\u0019A\u001a\u0002\u001bM$\u0018mZ5oOJ+\u0007o\\%e\u0011\u0015)\u0007\u00041\u0001P\u0003%9\u0007oZ*jO:,G\rF\u0003\\\u0003\u007f\u000b\u0019\r\u0003\u0004\u0002Bf\u0001\raW\u0001\u0005M&dW\r\u0003\u0004\u0002Ff\u0001\r!R\u0001\u0005CJ<7/\u0001\u0004nIVBW\r\u001f\u000b\u0005\u0003G\nY\rC\u0004\u0002Nj\u0001\r!a\u0019\u0002\u000b\tLH/Z:\u0002\u000fMD\u0017-\r5fqR!\u00111MAj\u0011\u001d\tim\u0007a\u0001\u0003G\n1!\u001c36+\t\tI\u000e\u0005\u0003\u0002\\\u0006\u0015XBAAo\u0015\u0011\ty.!9\u0002\u0011M,7-\u001e:jifT!!a9\u0002\t)\fg/Y\u0005\u0005\u0003O\fiNA\u0007NKN\u001c\u0018mZ3ES\u001e,7\u000f^\u0001\u0005g\"\f\u0017'\u0001\u0005iKb\f%O]1z)\u0011\ty/!?\u0011\t\u0005E\u0018q_\u0007\u0003\u0003gTA!!>\u0002b\u0006!A.\u00198h\u0013\ra\u00141\u001f\u0005\b\u0003wt\u0002\u0019AA2\u0003\r\t'O]\u0001\u0012'>t\u0017\r^=qKB+(\r\\5tQ\u0016\u0014\bC\u00016!'\t\u0001C\u0006\u0006\u0002\u0002\u0000\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002TC\u0001B\u0005U\r\t%1B\u0016\u0003\u0005\u001b\u0001BAa\u0004\u0003\u001a5\u0011!\u0011\u0003\u0006\u0005\u0005'\u0011)\"A\u0005v]\u000eDWmY6fI*\u0019!q\u0003\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001c\tE!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class SonatypePublisher {
    private final String uri;
    private final String snapshotUri;
    private final boolean signed;
    private final Seq<String> gpgArgs;
    private final Logger log;
    private final Path workspace;
    private final Map<String, String> env;
    private final int awaitTimeout;
    private final boolean stagingRelease;
    private final SonatypeHttpApi api;

    public static boolean $lessinit$greater$default$10() {
        return SonatypePublisher$.MODULE$.$lessinit$greater$default$10();
    }

    private SonatypeHttpApi api() {
        return this.api;
    }

    public void publish(Seq<Tuple2<Path, String>> fileMapping, Artifact artifact, boolean release) {
        this.publishAll(release, (Seq<Tuple2<Seq<Tuple2<Path, String>>, Artifact>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(fileMapping), (Object)artifact)}));
    }

    public void publishAll(boolean release, Seq<Tuple2<Seq<Tuple2<Path, String>>, Artifact>> artifacts) {
        Seq mappings = (Seq)artifacts.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SonatypePublisher.$anonfun$publishAll$1(check$ifrefutable$1))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq fileMapping0 = (Seq)tuple2._1();
                Artifact artifact = (Artifact)tuple2._2();
                String publishPath = new .colon.colon((Object)artifact.group().replace(".", "/"), (List)new .colon.colon((Object)artifact.id(), (List)new .colon.colon((Object)artifact.version(), (List)Nil$.MODULE$))).mkString("/");
                Seq fileMapping = (Seq)fileMapping0.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Path file = (Path)tuple2._1();
                        String name = (String)tuple2._2();
                        return new Tuple2((Object)file, (Object)new StringBuilder(1).append(publishPath).append("/").append(name).toString());
                    }
                    throw new MatchError((Object)tuple2);
                });
                Seq signedArtifacts = $this.signed ? (Seq)fileMapping.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Path file = (Path)tuple2._1();
                        String name = (String)tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.gpgSigned(file, $this.gpgArgs)), (Object)new StringBuilder(4).append(name).append(".asc").toString());
                    }
                    throw new MatchError((Object)tuple2);
                }) : (Seq)Nil$.MODULE$;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)artifact), ((IterableOps)fileMapping.$plus$plus((IterableOnce)signedArtifacts)).flatMap((Function1 & Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        Path file = (Path)tuple2._1();
                        String name = (String)tuple2._2();
                        byte[] content = read.bytes$.MODULE$.apply((ReadablePath)file);
                        return new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)content), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(4).append(name).append(".md5").toString()), (Object)this.md5hex(content)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(5).append(name).append(".sha1").toString()), (Object)this.sha1hex(content)), (List)Nil$.MODULE$)));
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple2 tuple2 = mappings.partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SonatypePublisher.$anonfun$publishAll$6(x$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq snapshots = (Seq)tuple2._1();
        Seq releases = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)snapshots, (Object)releases);
        Seq snapshots2 = (Seq)tuple22._1();
        Seq releases2 = (Seq)tuple22._2();
        if (snapshots2.nonEmpty()) {
            this.publishSnapshot((Seq<Tuple2<String, byte[]>>)((Seq)snapshots2.flatMap((Function1 & Serializable)x$4 -> (Seq)x$4._2())), (Seq<Artifact>)((Seq)snapshots2.map((Function1 & Serializable)x$5 -> (Artifact)x$5._1())));
        }
        Map releaseGroups = releases2.groupBy((Function1 & Serializable)x$6 -> ((Artifact)x$6._1()).group());
        releaseGroups.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SonatypePublisher.$anonfun$publishAll$10(check$ifrefutable$2))).foreach((Function1 & Serializable)x$11 -> {
            SonatypePublisher.$anonfun$publishAll$11(this, release, releases2, x$11);
            return BoxedUnit.UNIT;
        });
    }

    private void publishSnapshot(Seq<Tuple2<String, byte[]>> payloads, Seq<Artifact> artifacts) {
        this.publishToUri(payloads, artifacts, this.snapshotUri);
    }

    private void publishToUri(Seq<Tuple2<String, byte[]>> payloads, Seq<Artifact> artifacts, String uri) {
        Seq publishResults = (Seq)payloads.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String fileName = (String)tuple2._1();
                byte[] data = (byte[])tuple2._2();
                $this.log.info(new StringBuilder(10).append("Uploading ").append(fileName).toString());
                return this.api().upload(new StringBuilder(1).append(uri).append("/").append(fileName).toString(), data);
            }
            throw new MatchError((Object)tuple2);
        });
        this.reportPublishResults((Seq<Response>)publishResults, artifacts);
    }

    private void publishReleaseNonstaging(Seq<Tuple2<String, byte[]>> payloads, Seq<Artifact> artifacts) {
        this.publishToUri(payloads, artifacts, this.uri);
    }

    private void publishRelease(boolean release, Seq<Tuple2<String, byte[]>> payloads, String stagingProfile, Seq<Artifact> artifacts, int awaitTimeout) {
        String profileUri = this.api().getStagingProfileUri(stagingProfile);
        String stagingRepoId = this.api().createStagingRepo(profileUri, stagingProfile);
        String baseUri = new StringBuilder(31).append(this.uri).append("/staging/deployByRepositoryId/").append(stagingRepoId).append("/").toString();
        this.publishToUri(payloads, artifacts, baseUri);
        if (release) {
            this.log.info("Closing staging repository");
            this.api().closeStagingRepo(profileUri, stagingRepoId);
            this.log.info("Waiting for staging repository to close");
            this.awaitRepoStatus("closed", stagingRepoId, awaitTimeout);
            this.log.info("Promoting staging repository");
            this.api().promoteStagingRepo(profileUri, stagingRepoId);
            this.log.info("Waiting for staging repository to release");
            this.awaitRepoStatus("released", stagingRepoId, awaitTimeout);
            this.log.info("Dropping staging repository");
            this.api().dropStagingRepo(profileUri, stagingRepoId);
            this.log.info(new StringBuilder(23).append("Published ").append(((IterableOnceOps)artifacts.map((Function1 & Serializable)x$12 -> x$12.id())).mkString(", ")).append(" successfully").toString());
            return;
        }
    }

    private void reportPublishResults(Seq<Response> publishResults, Seq<Artifact> artifacts) {
        if (publishResults.forall((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.is2xx()))) {
            this.log.info(new StringBuilder(22).append("Published ").append(((IterableOnceOps)artifacts.map((Function1 & Serializable)x$14 -> x$14.id())).mkString(", ")).append(" to Sonatype").toString());
            return;
        }
        Seq errors = (Seq)((IterableOps)publishResults.filterNot((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.is2xx()))).map((Function1 & Serializable)response -> new StringBuilder(17).append("Code: ").append(response.statusCode()).append(", message: ").append(response.text()).toString());
        throw new RuntimeException(new StringBuilder(41).append("Failed to publish ").append(((IterableOnceOps)artifacts.map((Function1 & Serializable)x$16 -> x$16.id())).mkString(", ")).append(" to Sonatype. Errors: \n").append(errors.mkString("\n")).toString());
    }

    private void awaitRepoStatus(String status, String stagingRepoId, int awaitTimeout) {
        int attemptsLeft = awaitTimeout / 3000;
        while (attemptsLeft > 0 && !this.isRightStatus$1(stagingRepoId, status)) {
            Thread.sleep(3000L);
            if (--attemptsLeft != 0) continue;
            throw new RuntimeException(new StringBuilder(52).append("Couldn't wait for staging repository to be ").append(status).append(". Failing").toString());
        }
    }

    private Path gpgSigned(Path file, Seq<String> args) {
        String fileName = file.toString();
        Seq command = (Seq)((SeqOps)args.$plus$colon((Object)"gpg")).$colon$plus((Object)fileName);
        Jvm$.MODULE$.runSubprocess(command, this.env, this.workspace);
        return Path$.MODULE$.apply((Object)new StringBuilder(4).append(fileName).append(".asc").toString(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
    }

    private byte[] md5hex(byte[] bytes) {
        return this.hexArray(this.md5().digest(bytes)).getBytes();
    }

    private byte[] sha1hex(byte[] bytes) {
        return this.hexArray(this.sha1().digest(bytes)).getBytes();
    }

    private MessageDigest md5() {
        return MessageDigest.getInstance("md5");
    }

    private MessageDigest sha1() {
        return MessageDigest.getInstance("sha1");
    }

    private String hexArray(byte[] arr) {
        return String.format(new StringBuilder(3).append("%0").append(arr.length << 1).append("x").toString(), new BigInteger(1, arr));
    }

    public static final /* synthetic */ boolean $anonfun$publishAll$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$publishAll$6(Tuple2 x$2) {
        return ((Artifact)x$2._1()).isSnapshot();
    }

    public static final /* synthetic */ boolean $anonfun$publishAll$10(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$publishAll$11(SonatypePublisher $this, boolean release$1, Seq releases$1, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 != null) {
            String group = (String)tuple2._1();
            Seq groupReleases = (Seq)tuple2._2();
            if ($this.stagingRelease) {
                $this.publishRelease(release$1, (Seq<Tuple2<String, byte[]>>)((Seq)groupReleases.flatMap((Function1 & Serializable)x$7 -> (Seq)x$7._2())), group, (Seq<Artifact>)((Seq)releases$1.map((Function1 & Serializable)x$8 -> (Artifact)x$8._1())), $this.awaitTimeout);
                return;
            }
            $this.publishReleaseNonstaging((Seq<Tuple2<String, byte[]>>)((Seq)groupReleases.flatMap((Function1 & Serializable)x$9 -> (Seq)x$9._2())), (Seq<Artifact>)((Seq)releases$1.map((Function1 & Serializable)x$10 -> (Artifact)x$10._1())));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isRightStatus$1(String stagingRepoId$1, String status$1) {
        return this.api().getStagingRepoState(stagingRepoId$1).equalsIgnoreCase(status$1);
    }

    public SonatypePublisher(String uri, String snapshotUri, String credentials, boolean signed, Seq<String> gpgArgs, int readTimeout, int connectTimeout, Logger log, Path workspace, Map<String, String> env, int awaitTimeout, boolean stagingRelease) {
        this.uri = uri;
        this.snapshotUri = snapshotUri;
        this.signed = signed;
        this.gpgArgs = gpgArgs;
        this.log = log;
        this.workspace = workspace;
        this.env = env;
        this.awaitTimeout = awaitTimeout;
        this.stagingRelease = stagingRelease;
        this.api = new SonatypeHttpApi(uri, credentials, readTimeout, connectTimeout);
    }

    public SonatypePublisher(String uri, String snapshotUri, String credentials, boolean signed, Seq<String> gpgArgs, int readTimeout, int connectTimeout, Logger log, int awaitTimeout, boolean stagingRelease) {
        this(uri, snapshotUri, credentials, signed, gpgArgs, readTimeout, connectTimeout, log, os.package$.MODULE$.pwd(), (Map<String, String>)package$.MODULE$.env(), awaitTimeout, stagingRelease);
    }
}

