package com.linkare.booleval;

import com.linkare.jboolexpr.BooleanExpression;
import com.linkare.jboolexpr.MalformedBooleanException;

/**
 * 
 * @author Paulo Zenida
 * 
 *         Date: 2006-04-03
 */
public final class ExpressionValidator {

    private ExpressionValidator() {
    }

    /**
     * 
     * This evaluates boolean expressions, evaluating 'boolean' strings such as 'true&&false||true', returning the boolean computation. It uses an API from
     * SourceForge, JBooleanExpression, that can be downloaded <a href="http://sourceforge.net/projects/jboolexpr/">here</a>.
     * 
     * @param booleanExpression
     *            The booleanExpression to validate.
     * @return Returns true if the booleanExpression evaluation returns true. Returns false otherwise.
     * @throws MalformedBooleanException
     *             An exception when the booleanExpression is not a valid one. Supported operators are "||", "&&", "!" and parenthesis, to control boolean
     *             expression order.
     */
    public static synchronized boolean validate(String booleanExpression) throws MalformedBooleanException {
	if (booleanExpression.trim().length() == 0) {
	    return false;
	}
	boolean result = false;
	BooleanExpression boolExpr = null;
	boolExpr = BooleanExpression.readLeftToRight(booleanExpression);
	result = boolExpr.booleanValue();
	return result;
    }
}