package com.linkare.booleval.utils;

/**
 * 
 * @author Paulo Zenida
 * 
 *         Date 2006-04-05
 * 
 */
public final class WildcardToRegexUtility {

    private WildcardToRegexUtility() {
    }

    /**
     * 
     * @param wildcard
     *            The wildcard that will origin the regex.
     * @return Returns the wildcard string converted into a regex recognized by the Pattern.matches function.
     */
    public static synchronized String wildcardToRegex(String wildcard) {
	StringBuffer s = new StringBuffer(wildcard.length());
	s.append('^');
	for (int i = 0, is = wildcard.length(); i < is; i++) {
	    char c = wildcard.charAt(i);
	    switch (c) {
	    case '*':
		s.append(".*");
		break;
	    case '?':
		s.append(".?");
		break;
	    case '+':
		s.append(".+");
		break;
	    case '(':
	    case ')':
	    case '[':
	    case ']':
	    case '$':
	    case '^':
	    case '.':
	    case '{':
	    case '}':
	    case '|':
	    case '\\':
		s.append("\\");
		s.append(c);
		break;
	    default:
		s.append(c);
		break;
	    }
	}
	s.append('$');
	return (s.toString());
    }
}