package com.linkare.commons.dao;

/**
 * Base interface providing the contract semantics that any <code>deletable</code> type must fulfil. In order for a type to fulfil the <code>deletable</code>
 * interface, the <code>delete()</code> method must be implemented.
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
public interface Deletable {

    /**
     * In this method, one should remove any associations between this deletable type and any other associated types.
     * 
     * @return returns true if the type has been deleted. Returns false otherwise.
     */
    public boolean delete();
}