package com.linkare.commons.dao;

import java.io.Serializable;

/**
 * Base interface providing the contract semantics that any <code>identifiable</code> type must fulfil. In order for an <code>identifiable</code> type to fulfil
 * this contract, the method <code>id()</code> must be implemented. The returning type from the method <code>id()</code> is configurable through the parameter
 * <code>T</code>.
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 * @param <T>
 *            The identifier type for this type
 */
public interface Identifiable<T extends Serializable> {

    /**
     * 
     * @return Returns the identifier of this <code>identifiable</code> type.
     */
    public T id();
}