package com.linkare.commons.metainfo;

/**
 * This annotation should be used on any type or/and their elements, whenever it is required the creation of a changing "log" or note, performed by any member
 * of the Linkare TI company. Usually, this marker annotation is used on projects whose code is not Linkare's property.
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
public @interface Linkare {

    /**
     * 
     * @return Returns the author of the change performed.
     */
    String author() default "";

    /**
     * 
     * @return Returns a comment on the change performed. It may be used as the argument that lead to the change that was performed.
     */
    String comments() default "";
}