package com.linkare.commons.utils;

import java.util.List;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.TransformIterator;

public class CollectionUtils {

    /**
     * Transform a list of objects from one type to an array of another type, using a given transformer.
     * 
     * @param <F>
     *            Type from which the elements are converted.
     * @param <T>
     *            Type to which the elements will be converted.
     * @param list
     *            List of elements to be converted.
     * @param transformer
     *            Transformer used to convert each element.
     * @param clazz
     *            Class to which the elements will be transformed.
     * @return The array with all elements from the base list converted to the T type.
     */
    @SuppressWarnings("unchecked")
    public static <F, T> T[] getTransformedArrayFromList(List<F> list, Transformer transformer, Class<T> clazz) {

	TransformIterator iterator = new TransformIterator(list.iterator(), transformer);
	return (T[]) IteratorUtils.toArray(iterator, clazz);
    }

    /**
     * Transform an array of objects from one type to a list of objects of another type, using a given transformer.
     * 
     * @param <F>
     *            Type from which the elements are converted.
     * @param <T>
     *            Type to which the elements will be converted.
     * @param list
     *            Array of elements to be converted.
     * @param transformer
     *            Transformer used to convert each element.
     * @param clazzlist 
     *            Class to which the elements will be transformed.
     * @return The list with all elements from the base array converted to the T type.
     */
    @SuppressWarnings("unchecked")
    public static <F, T> List<T> getTransformedListFromArray(F[] list, Transformer transformer, Class<T> clazz) {

	TransformIterator iterator = new TransformIterator(new ArrayIterator(list), transformer);
	return IteratorUtils.toList(iterator);
    }

    /**
     * Transform an array of objects from one type to an array of objects of another type, using a given transformer.
     * 
     * @param <F>
     *            Type from which the elements are converted.
     * @param <T>
     *            Type to which the elements will be converted.
     * @param list
     *            Array of elements to be converted.
     * @param transformer
     *            Transformer used to convert each element.
     * @param clazz
     *            Class to which the elements will be transformed.
     * @return The array with all elements from the base array converted to the T type.
     */
    @SuppressWarnings("unchecked")
    public static <F, T> T[] getTransformedArrayFromArray(F[] list, Transformer transformer, Class<T> clazz) {

	TransformIterator iterator = new TransformIterator(new ArrayIterator(list), transformer);
	return (T[]) IteratorUtils.toArray(iterator, clazz);
    }

    /**
     * Transform a list of objects from one type to a list of objects of another type, using a given transformer.
     * 
     * @param <F>
     *            Type from which the elements are converted.
     * @param <T>
     *            Type to which the elements will be converted.
     * @param list
     *            List of elements to be converted.
     * @param transformer
     *            Transformer used to convert each element.
     * @param clazz
     *            Class to which the elements will be transformed.
     * @return The list with all elements from the base list converted to the T type.
     */
    @SuppressWarnings("unchecked")
    public static <F, T> List<T> getTransformedListFromList(List<F> list, Transformer transformer, Class<T> clazz) {

	TransformIterator iterator = new TransformIterator(list.iterator(), transformer);
	return IteratorUtils.toList(iterator);
    }

    /**
     * Transformer that converts any object in a String representation of itself, using the toString method of the object.
     * 
     * @return
     */
    public static Transformer getToStringTransformer() {
	return new Transformer() {
	    public String transform(Object obj) {
		return obj.toString();
	    }
	};
    }
}
