package com.linkare.commons.utils;

/**
 * 
 * This class aggregates common functions to check for equality between objects.
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
public final class EqualityUtils {

    /**
     * Hiding constructor so that this utility class cannot be instantiated from outside.
     */
    private EqualityUtils() {
    }

    /**
     * 
     * @param <T>
     *            the type of the arguments to check for equality. The objects being compared must be of the same type. Therefore, the clients of this method
     *            should, explicitly, specify the argument type, something like <code>EqualityUtils.<String>(s1, s2)</code>. When that specification is not
     *            performed, through the automatic erasure mechanism within Java, the argument type is inferred to the highest class of both arguments (Object,
     *            when necessary).
     * 
     * @param object1
     *            The object to be compared from.
     * @param object2
     *            The object to be compared to.
     * @return Returns the equality between <code>object1</code> and <code>object2</code> where, if <code>object1</code> is null, then <code>object2</code> must
     *         be null as well. Otherwise, call equals on the <code>object1</code>.
     */
    public static <T> boolean equals(final T object1, final T object2) {
	return object1 == null ? object2 == null : object1.equals(object2);
    }
}