package com.linkare.commons.utils;

import java.io.Serializable;

/**
 * Generic class to represent a relation between two different objects (the key and the value).
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 * @param <K>
 *            The key type element in this pair.
 * @param <V>
 *            The value type element in this pair.
 */
public final class Pair<K, V> implements Serializable {

    private static final long serialVersionUID = 2751481580164361831L;

    private static final int HASH_CODE_INIT = 14;

    private static final int HASH_CODE_MULTIPLIER = 29;

    private final K key;

    private final V value;

    /**
     * 
     * @param key
     *            the key to set.
     * @param value
     *            the value to set.
     */
    public Pair(K key, V value) {
	this.key = key;
	this.value = value;
    }

    /**
     * 
     * @return the key.
     */
    public K getKey() {
	return key;
    }

    /**
     * 
     * @return the value.
     */
    public V getValue() {
	return value;
    }

    @Override
    public String toString() {
	return getKey() + "," + getValue();
    }

    @Override
    @SuppressWarnings("unchecked")
    public boolean equals(final Object other) {
	if (!(other instanceof Pair)) {
	    return false;
	}
	return equalsTo(Pair.class.cast(other));
    }

    @Override
    public int hashCode() {
	int result = HASH_CODE_INIT;
	result = HASH_CODE_MULTIPLIER * result + (getKey() != null ? getKey().hashCode() : 0);
	result = HASH_CODE_MULTIPLIER * result + (getValue() != null ? getValue().hashCode() : 0);
	return result;
    }

    /**
     * 
     * @param other
     *            the other to be compared with the implicit pair.
     * @return true if <code>other</code> is equal to <code>this</code>. Returns false otherwise.
     * @see EqualityUtils#equals(Object, Object)
     */
    private boolean equalsTo(final Pair<K, V> other) {
	return EqualityUtils.<K> equals(getKey(), other.getKey()) && EqualityUtils.<V> equals(getValue(), other.getValue());
    }
}