/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.communications.smtp;

import com.linkare.commons.communications.smtp.Authenticator;
import com.linkare.commons.utils.PropertiesManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.validator.EmailValidator;

public class EmailSender {
    private static final String MAIL_CONTENT_TYPE = "mail.content.type";
    private static final String MAIL_SENDER_MAX_RECIPIENTS = "mailSender.max.recipients";
    private static final String SMTP_PROPERTIES = "/smtp.properties";
    private static final String CONTENT_TYPE;
    private static final int MAX_MAIL_RECIPIENTS;
    private static final Session session;
    private static Logger Log;

    public static Collection<String> forward(MimeMessage message, List<String> bccAddressesToforward) {
        if (message == null) {
            throw new NullPointerException("error.message.cannot.be.null");
        }
        ArrayList<String> unsent = new ArrayList<String>(0);
        ArrayList<String> bccAddressesList = new ArrayList<String>(new HashSet<String>(bccAddressesToforward));
        for (int i = 0; i < bccAddressesList.size(); i += MAX_MAIL_RECIPIENTS) {
            List<String> subList = bccAddressesList.subList(i, Math.min(bccAddressesList.size(), i + MAX_MAIL_RECIPIENTS));
            try {
                MimeMessage newMessage = new MimeMessage(message);
                newMessage.setRecipients(MimeMessage.RecipientType.TO, (Address[])new InternetAddress[0]);
                newMessage.setRecipients(MimeMessage.RecipientType.CC, (Address[])new InternetAddress[0]);
                newMessage.setRecipients(MimeMessage.RecipientType.BCC, (Address[])new InternetAddress[0]);
                EmailSender.addRecipients((Message)newMessage, Message.RecipientType.BCC, subList, unsent);
                Transport.send((Message)newMessage);
                continue;
            }
            catch (SendFailedException e) {
                EmailSender.registerInvalidAddresses(unsent, e, null, null, subList);
                continue;
            }
            catch (MessagingException e) {
                if (subList != null) {
                    unsent.addAll(subList);
                }
                e.printStackTrace();
            }
        }
        return unsent;
    }

    private static String encode(String string) {
        try {
            return MimeUtility.encodeText((String)string);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return string;
        }
    }

    public static Collection<String> send(String fromName, String fromAddress, String[] replyTos, Collection<String> toAddresses, Collection<String> ccAddresses, Collection<String> bccAddresses, String subject, String body) {
        return EmailSender.send(fromName, fromAddress, replyTos, toAddresses, ccAddresses, bccAddresses, subject, body, CONTENT_TYPE, null);
    }

    public static Collection<String> send(String fromName, String fromAddress, String[] replyTos, Collection<String> toAddresses, Collection<String> ccAddresses, Collection<String> bccAddresses, String subject, String body, List<String> attachments) {
        return EmailSender.send(fromName, fromAddress, replyTos, toAddresses, ccAddresses, bccAddresses, subject, body, CONTENT_TYPE, attachments);
    }

    public static void send(String fromName, String fromAddress, String to, String subject, String body) {
        ArrayList<String> toAddresses = new ArrayList<String>();
        toAddresses.add(to);
        ArrayList<String> emptyAddresses = new ArrayList<String>();
        String[] replyTo = new String[]{fromAddress};
        EmailSender.send(fromName, fromAddress, replyTo, toAddresses, emptyAddresses, emptyAddresses, subject, body, CONTENT_TYPE, null);
    }

    private static void addAttachment(MimeMultipart multipart, List<String> attachmentsList) throws MessagingException {
        for (String fileAttachment : attachmentsList) {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(fileAttachment);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            int indexOf = fileAttachment.lastIndexOf("/") == -1 ? fileAttachment.lastIndexOf("\\") : fileAttachment.lastIndexOf("/");
            String newFileName = indexOf > 0 ? fileAttachment.substring(indexOf + 1) : fileAttachment;
            messageBodyPart.setFileName(newFileName);
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
    }

    public static Collection<String> send(String fromName, String fromAddress, String[] replyTos, Collection<String> toAddresses, Collection<String> ccAddresses, Collection<String> bccAddresses, String subject, String body, String contentType) {
        return EmailSender.send(fromName, fromAddress, replyTos, toAddresses, ccAddresses, bccAddresses, subject, body, contentType, null);
    }

    public static Collection<String> send(String fromName, String fromAddress, String[] replyTos, Collection<String> toAddresses, Collection<String> ccAddresses, Collection<String> bccAddresses, String subject, String body, String contentType, List<String> attachmentsList) {
        boolean hasAttachments;
        if (fromAddress == null) {
            throw new NullPointerException("error.from.address.cannot.be.null");
        }
        ArrayList<String> unsentAddresses = new ArrayList<String>(0);
        Address[] replyToAddresses = new Address[replyTos == null ? 0 : replyTos.length];
        if (replyTos != null) {
            for (int i = 0; i < replyTos.length; ++i) {
                try {
                    replyToAddresses[i] = new InternetAddress(EmailSender.encode(replyTos[i]));
                    continue;
                }
                catch (AddressException e) {
                    throw new Error("invalid.reply.to.address: " + replyTos[i]);
                }
            }
        }
        String from = EmailSender.constructFromString(EmailSender.encode(fromName), fromAddress);
        boolean hasToAddresses = toAddresses != null && !toAddresses.isEmpty();
        boolean hasCCAddresses = ccAddresses != null && !ccAddresses.isEmpty();
        boolean bl = hasAttachments = attachmentsList != null && !attachmentsList.isEmpty();
        if (hasToAddresses || hasCCAddresses) {
            try {
                MimeMessage mimeMessageTo = new MimeMessage(session);
                mimeMessageTo.setFrom((Address)new InternetAddress(from));
                mimeMessageTo.setSubject(EmailSender.encode(subject));
                mimeMessageTo.setReplyTo(replyToAddresses);
                if (hasToAddresses) {
                    EmailSender.addRecipients((Message)mimeMessageTo, Message.RecipientType.TO, toAddresses, unsentAddresses);
                }
                if (hasCCAddresses) {
                    EmailSender.addRecipients((Message)mimeMessageTo, Message.RecipientType.CC, ccAddresses, unsentAddresses);
                }
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setContent((Object)body, contentType);
                MimeMultipart mimeMultipart = new MimeMultipart();
                mimeMultipart.addBodyPart((BodyPart)bodyPart);
                if (hasAttachments) {
                    EmailSender.addAttachment(mimeMultipart, attachmentsList);
                }
                mimeMessageTo.setContent((Multipart)mimeMultipart);
                Transport.send((Message)mimeMessageTo);
            }
            catch (SendFailedException e) {
                EmailSender.registerInvalidAddresses(unsentAddresses, e, toAddresses, ccAddresses, null);
            }
            catch (MessagingException e) {
                if (toAddresses != null) {
                    unsentAddresses.addAll(toAddresses);
                }
                if (ccAddresses != null) {
                    unsentAddresses.addAll(ccAddresses);
                }
                e.printStackTrace();
            }
        }
        if (bccAddresses != null && !bccAddresses.isEmpty()) {
            ArrayList<String> bccAddressesList = new ArrayList<String>(new HashSet<String>(bccAddresses));
            for (int i = 0; i < bccAddressesList.size(); i += MAX_MAIL_RECIPIENTS) {
                List<String> subList = null;
                try {
                    subList = bccAddressesList.subList(i, Math.min(bccAddressesList.size(), i + MAX_MAIL_RECIPIENTS));
                    MimeMessage message = new MimeMessage(session);
                    message.setFrom((Address)new InternetAddress(from));
                    message.setSubject(EmailSender.encode(subject));
                    message.setReplyTo(replyToAddresses);
                    EmailSender.addRecipients((Message)message, Message.RecipientType.BCC, subList, unsentAddresses);
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setContent((Object)body, contentType);
                    MimeMultipart mimeMultipart = new MimeMultipart();
                    mimeMultipart.addBodyPart((BodyPart)bodyPart);
                    if (hasAttachments) {
                        EmailSender.addAttachment(mimeMultipart, attachmentsList);
                    }
                    message.setContent((Multipart)mimeMultipart);
                    Transport.send((Message)message);
                    continue;
                }
                catch (SendFailedException e) {
                    EmailSender.registerInvalidAddresses(unsentAddresses, e, null, null, subList);
                    continue;
                }
                catch (MessagingException e) {
                    if (subList != null) {
                        unsentAddresses.addAll(subList);
                    }
                    e.printStackTrace();
                }
            }
        }
        return unsentAddresses;
    }

    private static void registerInvalidAddresses(Collection<String> unsentAddresses, SendFailedException e, Collection<String> toAddresses, Collection<String> ccAddresses, Collection<String> bccAddresses) {
        e.printStackTrace();
        if (e.getValidUnsentAddresses() != null) {
            for (int i = 0; i < e.getValidUnsentAddresses().length; ++i) {
                unsentAddresses.add(e.getValidUnsentAddresses()[i].toString());
            }
        } else if (e.getValidSentAddresses() == null || e.getValidSentAddresses().length == 0) {
            if (toAddresses != null) {
                unsentAddresses.addAll(toAddresses);
            }
            if (ccAddresses != null) {
                unsentAddresses.addAll(ccAddresses);
            }
            if (bccAddresses != null) {
                unsentAddresses.addAll(bccAddresses);
            }
        }
    }

    protected static String constructFromString(String fromName, String fromAddress) {
        return fromName == null || fromName.length() == 0 ? fromAddress : "\"" + fromName + "\" <" + fromAddress + ">";
    }

    private static void addRecipients(Message message, Message.RecipientType recipientType, Collection<String> emailAddresses, Collection<String> unsentMails) throws MessagingException {
        if (emailAddresses != null) {
            for (String emailAddress : emailAddresses) {
                try {
                    EmailValidator validator = EmailValidator.getInstance();
                    if (validator.isValid(emailAddress)) {
                        Log.fine("Sending to: " + emailAddress);
                        message.addRecipient(recipientType, (Address)new InternetAddress(EmailSender.encode(emailAddress)));
                        continue;
                    }
                    Log.fine("skipped: " + emailAddress);
                    unsentMails.add(emailAddress);
                }
                catch (AddressException e) {
                    Log.fine("skipped due to address exception: " + emailAddress);
                    unsentMails.add(emailAddress);
                }
            }
        }
    }

    static {
        try {
            Log = Logger.getLogger("EmailSender");
            Properties properties = new Properties();
            PropertiesManager.loadProperties(properties, SMTP_PROPERTIES);
            Authenticator authenticator = new Authenticator(properties);
            session = Session.getInstance((Properties)properties, (javax.mail.Authenticator)authenticator);
            MAX_MAIL_RECIPIENTS = Integer.parseInt(properties.getProperty(MAIL_SENDER_MAX_RECIPIENTS));
            CONTENT_TYPE = properties.getProperty(MAIL_CONTENT_TYPE);
        }
        catch (IOException e) {
            Log.severe("error.initializing.EmailSender: " + e.toString());
            throw new RuntimeException(e);
        }
    }
}

