/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.utils;

import com.linkare.commons.utils.EqualityUtils;
import java.io.Serializable;

public final class Pair<K, V>
implements Serializable {
    private static final long serialVersionUID = 2751481580164361831L;
    private static final int HASH_CODE_INIT = 14;
    private static final int HASH_CODE_MULTIPLIER = 29;
    private final K key;
    private final V value;

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public String toString() {
        return this.getKey() + "," + this.getValue();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Pair)) {
            return false;
        }
        return this.equalsTo((Pair)Pair.class.cast(other));
    }

    public int hashCode() {
        int result = 14;
        result = 29 * result + (this.getKey() != null ? this.getKey().hashCode() : 0);
        result = 29 * result + (this.getValue() != null ? this.getValue().hashCode() : 0);
        return result;
    }

    private boolean equalsTo(Pair<K, V> other) {
        return EqualityUtils.equals(this.getKey(), other.getKey()) && EqualityUtils.equals(this.getValue(), other.getValue());
    }
}

